% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countFeatures.R
\name{countFeatures}
\alias{countFeatures}
\title{countFeatures}
\usage{
countFeatures(
  bamfiles,
  bins,
  strandSpecific = 0,
  readLength = 50L,
  allowMultiOverlap = TRUE,
  inclNormalized = TRUE,
  tmpDir = tempdir(),
  ...
)
}
\arguments{
\item{bamfiles}{A vector of paths to bam files}

\item{bins}{A GRanges of bins in which to count reads (or path to a rds file
containing such an object}

\item{strandSpecific}{Passed to `Rsubread::featureCounts`}

\item{readLength}{Used as a minimum width to estimate read density.}

\item{allowMultiOverlap}{Passed to `Rsubread::featureCounts`}

\item{inclNormalized}{Logical; whether to include normalized assays (needed
for plotting)}

\item{tmpDir}{Passed to `Rsubread::featureCounts`}

\item{...}{Passed to `Rsubread::featureCounts`}
}
\value{
A \link[SummarizedExperiment]{RangedSummarizedExperiment-class}
}
\description{
countFeatures
}
\examples{
data("example_gene_annotation", package="diffUTR")
bins <- prepareBins(example_gene_annotation)
bam_files <- list.files(system.file("extdata", package="diffUTR"),
                        pattern="bam$", full=TRUE)
# not run
# se <- countFeatures(bam_files, bins, verbose=FALSE)
}
