% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotTopGenes}
\alias{plotTopGenes}
\title{plotTopGenes}
\usage{
plotTopGenes(se, n = 10, FDR = 0.05, diffUTR = FALSE, alpha = 1, ...)
}
\arguments{
\item{se}{A bin-wise SummarizedExperiment as produced by
\code{\link{countFeatures}} and including bin-level tests (i.e. having been
passed through one of the DEU wrappers such as
\code{\link{diffSpliceWrapper}} or \code{\link{DEXSeqWrapper}})}

\item{n}{The maximum number of genes for which to plot labels}

\item{FDR}{The FDR threshold above which to plot labels}

\item{diffUTR}{Logical; if FALSE, uses absolute coefficients (appropriate
for normal differential exon usage); if TRUE, uses non-absolute (ie changes
should be in the same direction across significant bins) and width-weighted
scores (i.e. larger bins have more weight) -- this is relevant only when
testing UTR usage.}

\item{alpha}{Points transparency}

\item{...}{Passed to \link[ggrepel]{geom_label_repel}; this can for instance
be used to increase `max.overlaps` when not all desired gene labels are 
displayed)}
}
\value{
A ggplot
}
\description{
plotTopGenes
}
\examples{
data(example_bin_se)
se <- diffSpliceWrapper(example_bin_se, ~condition)
plotTopGenes(se)
}
