% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contingencyTest.R
\name{contingencyTest}
\alias{contingencyTest}
\title{Contingency test for count data}
\usage{
contingencyTest(microCount, chisq = TRUE, fisher = TRUE,
                alternative = c("greater"))
}
\arguments{
\item{microCount}{a \emph{m by 2} data frame or numeric matrix of contingency table with frequencies under each condition-impact term; could be produced from \code{\link{contingencyCount}}.}

\item{chisq, fisher}{logical indicating if the Chi-squared test or Fisher's exact test should be performed.}

\item{alternative}{parameter specifying for alternative hypothesis, only used when \code{fisher} is \code{TRUE}; see \code{\link[stats]{fisher.test}}.}
}
\value{
A list with following components:
Chisq Chi-squared test results for each pair-wise condition.
Chisq.p the p-values of the Chi-squared tests for all pair-wise conditions.
Fisher Fisher's exact test results for each pair-wise condition.
Fisher.p the p-values of the Fisher's exact tests for all pair-wise conditions.
}
\description{
Performs Chi-squared test or Fisher's exact test for testing the significance of association between conditions and eubiotic/dysbiotic impacts in a contingency table.
}
\details{
Chi-squared test for testing the probability that  the proportions of eubiotic frequencies are different between two conditions; furtherly, the Fisher's exact test for testing whether one condition is more likely to be associated to eubiotic impact. More details, refer to \code{\link[stats]{chisq.test}} and \code{\link[stats]{fisher.test}}
}
\examples{
data(microCount)

test = contingencyTest(microCount,chisq = TRUE,fisher = TRUE,
           alternative = "greater")
chisq.p = test[["Chisq.p"]]
fisher.p = test[["Fisher.p"]]
}
\seealso{
\code{\link{contingencyCount}}, \code{\link[stats]{fisher.test}}, \code{\link[stats]{chisq.test}}
}

