% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetPlot.R
\name{upsetPlot}
\alias{upsetPlot}
\title{UpSet plot for the Venn count table}
\usage{
upsetPlot(
  vennTable,
  label_all = list(na.rm = TRUE, color = "gray30", alpha = 0.7, label.padding = unit(0.1,
    "lines")),
  coln_prefix = NULL,
  ...
)
}
\arguments{
\item{vennTable}{An vennTable object, the first element in the output of
\link{vennCount}.}

\item{label_all}{A list of parameters used by \link[ggplot2]{geom_label} for
text labels of counts for each group. If it set to FALSE or length of the
list is zero, the labels will be ignored.}

\item{coln_prefix}{The prefix to be removed for column names of vennTable.}

\item{...}{Parameters could be passed to \link[ComplexUpset:upset]{upset}
except \code{data} and \code{intersect}.}
}
\value{
A ggplot object.
}
\description{
Plot the overlaps counts by ComplexUpset.
}
\examples{
pd <- system.file("extdata", package = "hicVennDiagram", mustWork = TRUE)
fs <- dir(pd, pattern = ".bedpe", full.names = TRUE)
vc <- vennCount(fs)
upset_themes_fix <- lapply(ComplexUpset::upset_themes, function(.ele){
.ele[names(.ele) \%in\% names(formals(ggplot2::theme))]
})
upsetPlot(vc, theme = upset_themes_fix)
## change the font size of lables and numbers
themes <- ComplexUpset::upset_modify_themes(
 ## get help by vignette('Examples_R', package = 'ComplexUpset')
        list('intersections_matrix'=
            ggplot2::theme(axis.text.y=ggplot2::element_text(size=24)))
)
themes <- lapply(themes, function(.ele){
.ele[names(.ele) \%in\% names(formals(ggplot2::theme))]
})
upsetPlot(vc, label_all=list(
                        na.rm = TRUE,
                        color = 'gray30',
                        alpha = .7,
                        label.padding = grid::unit(0.1, "lines"),
                        size = 5
), themes = themes)
}
