% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Correlation_Regression.R
\name{allToAllProduct}
\alias{allToAllProduct}
\title{\code{allToAllProduct} creates a dataframe of snp and taxa correlations}
\usage{
allToAllProduct(SnpFile, microbeAbund, rsID = NULL)
}
\arguments{
\item{SnpFile}{the snp file (rownames is sample number and colnames is the snps)}

\item{microbeAbund}{he taxa abundance dataframe (rownames sample names and colnames taxa Genus/species/family)}

\item{rsID}{Default is NULL and will run across the who dataset unless specific rsID/SNP/chr_region is specified}
}
\value{
A dataframe of correlations between snps and taxa
}
\description{
This internal function takes the original snp dataframe and returns a long parsed snp dataframe
}
\examples{
data(microbeAbund)
data(SnpFile)
x <- allToAllProduct(SnpFile, microbeAbund, "chr1.171282963_T")

}
\keyword{Correlation}
\keyword{snptaxa}
