% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetagenomeSeqconverter.R
\name{metagenomeSeqToMbqtl}
\alias{metagenomeSeqToMbqtl}
\title{\subsection{Written by Mercedeh Movassagh \href{mailto:mercedeh@ds.dfci.harvard.edu}{mercedeh@ds.dfci.harvard.edu}, January 2023}{

metagenomeSeqToMbqtl Converts metagenomeSeq obj to compatible taxa dataframe
}}
\usage{
metagenomeSeqToMbqtl(meta_glom, norm, log, aggregate_taxa = NULL)
}
\arguments{
\item{meta_glom}{\code{MRexperiement} class obj from \code{metagenomeSeq} package.}

\item{norm}{A logical indicating whether or not to return normalized counts.}

\item{log}{TRUE/FALSE whether or not to log2 transform scale.}

\item{aggregate_taxa}{it is recommended that the normalization occurs at taxa level (default NULL)
however, if the user chooses to aggregate on the phyla/family/Genus or Species
level before normalization they have the option.}
}
\value{
A data frame of normalized/not normalized counts compatible with \code{mbQTL}.
}
\description{
This function takes and \code{MRexperiement} class object transforms it and makes the result dataframe compatible
with \code{mbQTL} taxa input file
}
\examples{
data(metagenomeSeqObj)
x <- metagenomeSeqToMbqtl(metagenomeSeqObj, norm = TRUE, log = TRUE, aggregate_taxa = NULL)
}
\keyword{MRexperiment}
\keyword{metagenomeSeq}
\keyword{normalization}
