% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{QData}
\alias{QData}
\alias{QData,metabCombiner-method}
\title{Retrieve Relative Abundance Values}
\usage{
QData(object, data = NULL, value = c("obs", "mean"))

\S4method{QData}{metabCombiner}(object, data = NULL, value = c("observed", "mean"))
}
\arguments{
\item{object}{\code{metabCombiner} object}

\item{data}{dataset identifier to extract information from; if NULL,
extracts information from all datasets}

\item{value}{Either "obs" (observed - default option) or "mean" average value}
}
\value{
data frame or vector of relative ranked abundance (Q) values

data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")
p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##retrieve all Q
Q <- QData(p.comb, data = NULL)

##retrieve Q from p30
Q <- QData(p.comb, data = "p30")

##retrieve mean Q
Q <- QData(p.comb, value = "mean")
}
\description{
This retrieves feature Q values from one or all constituent
dataset features of a \code{metabCombiner} object. Alternatively, the average
Q value can be retrieved.
}
