% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{combinedTable}
\alias{combinedTable}
\alias{combinedTable,metabCombiner-method}
\title{Obtain Feature Alignment Report}
\usage{
combinedTable(object)

\S4method{combinedTable}{metabCombiner}(object)
}
\arguments{
\item{object}{\code{metabCombiner} object.}
}
\value{
Feature Pair Alignment report data frame. The columns of the report
are as follows:

\item{idx}{Identities of features from dataset X}
\item{idy}{Identities of features from dataset Y}
\item{mzx}{m/z values of features from dataset X}
\item{mzy}{m/z values of features from dataset Y}
\item{rtx}{retention time values of features from dataset X}
\item{rty}{retention time values of features from dataset Y}
\item{rtProj}{model-projected (X->Y) retention times values}
\item{Qx}{abundance quantile values of features from dataset X}
\item{Qy}{abundance quantile values of features from dataset Y}
\item{group}{m/z feature group of feature pairing}
\item{score}{computed similarity scores of feature pairing}
\item{rankX}{ranking of pairing score for X dataset features}
\item{rankY}{ranking of pairing score for Y dataset features}
\item{adductX}{adduct label of features from dataset X}
\item{adductY}{adduct label of features from dataset Y}
\item{...}{Sample and extra columns from both datasets X & Y}
}
\description{
Obtain constructed table reporting every feature pair alignment.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")

p.comb <- metabCombiner(p30, p20)
p.comb.table <- combinedTable(p.comb)

}
