% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{fitloessParam}
\alias{fitloessParam}
\title{List fitLoess Defaults}
\usage{
fitloessParam(
  useID = FALSE,
  spans = seq(0.2, 0.3, by = 0.02),
  outlier = "MAD",
  coef = 2,
  iterFilter = 2,
  prop = 0.5,
  weights = 1,
  message = TRUE,
  rtx = c("min", "max"),
  rty = c("min", "max"),
  control = loess.control(surface = "direct", iterations = 10)
)
}
\arguments{
\item{useID}{choice of preserving identity-based anchors; default: FALSE}

\item{spans}{values for span parameter which controls degree of smoothing}

\item{outlier}{outlier filtering method (either "MAD" or "boxplot");
default: "MAD"}

\item{coef}{outlier filtering coefficient; default: 2}

\item{iterFilter}{number of outlier filtering iterations; default: 2}

\item{prop}{minimum proportion of fits where a point can be a flagged outlier;
default: 0.5}

\item{weights}{optional supplied weights to individual points; default: 1}

\item{message}{option to print progress message; default: TRUE}

\item{rtx}{ordered pair of endpoints for rtx; default: ("min", "max")}

\item{rty}{ordered pair of endpoints for rty; default: ("min", "max")}

\item{control}{loess-specific control parameters; see: ?loess.control}
}
\value{
list of fit_loess parameters:
}
\description{
List of default parameters for loess fitting step of main package workflow,
See help(fit_loess) or ?fit_loess for more details.
}
\examples{
fitParam <- fitloessParam(spans = c(0.2,0.25,0.3), outlier = "boxplot",
                         iterFilter = 3, coef = 1.5, message = FALSE,
                         control = loess.control(iterations = 4))

}
\seealso{
\code{\link{fit_loess}}, \code{\link{metabCombine}}
}
