% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{idData}
\alias{idData}
\alias{idData,metabCombiner-method}
\title{Retrieve Feature Identities}
\usage{
idData(object, data = NULL)

\S4method{idData}{metabCombiner}(object, data = NULL)
}
\arguments{
\item{object}{\code{metabCombiner} object}

\item{data}{dataset identifier to extract information from; if NULL, extracts
information from all datasets}
}
\value{
data frame of feature identities
}
\description{
This retrieves user-assigned feature identities from one or
all constituent datasets of a \code{metabCombiner} object
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")
p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##retrieve all ids
ids <- idData(p.comb, data = NULL)

##retrieve ids from p30
ids <- idData(p.comb, data = "p30")

}
