% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinerCheck.R
\name{isCombinedTable}
\alias{isCombinedTable}
\title{Determine \code{combinedTable} Validity}
\usage{
isCombinedTable(object)
}
\arguments{
\item{object}{Any R object.}
}
\value{
0 if object is a valid Combiner Table; an integer code otherwise
}
\description{
Checks whether input object is a valid metabData.Returns an
integer code if invalid. Function is used alongside \code{combinerCheck}.
}
\details{
a proper \code{combinedTable} must have these characteristics to
be deemed valid for \code{metabCombiner} operations:

1) It must be a data.frame with at least 16 columns and at least 1 row

2) The first 16 columns must be named "rowID", "idx","idy","mzx","mzy","rtx",
   "rty", "rtProj","Qx","Qy","group","score","rankX","rankY","adductx", &
   "adducty" in this exact order

3) The first 16 columns must be of class: "numeric" "character","character",
   "numeric","numeric","numeric", "numeric", "numeric","numeric","numeric",
   "integer", "numeric", "integer", "integer","character", "character"

4)  The group column must have no missing or negative values

Failing any one of these criteria causes an error
}
