% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{labelRowsParam}
\alias{labelRowsParam}
\alias{reduceTableParam}
\title{List labelRows & reduceTable Defaults}
\usage{
labelRowsParam(
  useID = FALSE,
  maxRankX = 3,
  maxRankY = 3,
  minScore = 0.5,
  method = "score",
  delta = 0.1,
  maxRTerr = 10,
  resolveConflicts = FALSE,
  rtOrder = TRUE,
  remove = FALSE,
  balanced = TRUE,
  brackets_ignore = c("(", "[", "{")
)

reduceTableParam(
  useID = FALSE,
  maxRankX = 2,
  maxRankY = 2,
  minScore = 0.5,
  maxRTerr = 10,
  delta = 0.1,
  rtOrder = TRUE,
  method = "score",
  brackets_ignore = c("(", "[", "{")
)
}
\arguments{
\item{useID}{option to annotate identity-matched strings as IDENTITY;
default: FALSE}

\item{maxRankX}{maximum rank allowable for X features}

\item{maxRankY}{maximum rank allowable for Y features}

\item{minScore}{minimum score threshold; default: 0.5}

\item{method}{thresholding method for subgroup detection ("score" or "mzrt");
default: "score"}

\item{delta}{score distance or mz/rt difference tolerances for subgrouping;
default: 0.1}

\item{maxRTerr}{maximum allowable difference between predicted RT (rtProj) &
observed RT (rty); default: 10 minutes}

\item{resolveConflicts}{logical. If TRUE, automatically resolves subgroups to
1-1 feature pair alignments}

\item{rtOrder}{logical. If TRUE and resolveConflicts is TRUE, imposes
retention order condition on paired alignments}

\item{remove}{option to eliminate rows determined as removable;
default: FALSE}

\item{balanced}{option to reduce balanced groups; default: TRUE}

\item{brackets_ignore}{bracket types for ignoring string comparisons}
}
\value{
list of labelRows parameters
}
\description{
List of default parameters for combinedTable row annotation and removal.
See help(labelRows) or ?labelRows for more details. reduceTableParam loads
parameters for the more automated \code{reduceTable} function
}
\examples{
lrParams <- labelRowsParam(maxRankX = 2, maxRankY = 2, delta = 0.1,
                             maxRTerr = 0.5)

}
\seealso{
\code{\link{labelRows}}, \code{\link{metabCombine}},
\code{\link{batchCombine}}, \code{\link{reduceTable}}
}
