% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcScores.R
\name{mzFit}
\alias{mzFit}
\title{Compute m/z Shift Model}
\usage{
mzFit(object, fit = mzfitParam(), plot = TRUE, ...)
}
\arguments{
\item{object}{metabCombiner object}

\item{fit}{List of m/z shift parameter values; see ?mzfitParam}

\item{plot}{Logical. Option to plot the m/z shift model.}

\item{...}{other arguments to be passed to plot}
}
\value{
model object of class gam or 0 (if no model selected)
}
\description{
Generates a GAM model for correcting systematic m/z shifts
observed between a pair of LC-MS data sets.
}
\details{
Correcting for systematic m/z shifts improves the scores for
feature pair alignments, yielding more accurate match hypotheses. This
function generates a basis spline curve, modeling the m/z shift (mzy - mzx)
as a function of m/z (mzx). Selected points are ordered feature pairs that
meet criteria for m/z, RT (rty vs rtProj), and Q tolerances set in the
\code{mzfit} list argument (see: \code{\link{mzfitParam}}). If

Setting the \code{plot} option to TRUE generates an image of the curve fit
through the selected points and is a useful method for determining if
m/z mapping is appropriate for the analysis and tuning certain parameters.

This function is called within \code{\link{calcScores}}, which can help
improve the pairwise scores
}
\examples{

\donttest{
data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb <- metabCombiner(xdata = p30, ydata = p20, binGap = 0.0075)

p.comb <- selectAnchors(p.comb, tolmz = 0.003, tolQ = 0.3, windy = 0.02)
p.comb <- fit_gam(p.comb, k = 20, iterFilter = 1, family = "gaussian")

mzmodel <- mzFit(p.comb, plot = TRUE,
                 fit = mzfitParam(mz = 0.003, rt = 0.03, Q = 0.3, k = 20))

}

}
