% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcScores.R
\name{mzfitParam}
\alias{mzfitParam}
\title{Parameterize m/z Shift Model}
\usage{
mzfitParam(mz = 0.003, rt = 0.03, Q = 0.3, k = 10)
}
\arguments{
\item{mz}{Numeric. Limits the m/z distance between feature pairs for modeling}

\item{rt}{Numeric. Limits the RT distance between feature pairs for modeling
(note: this is proportion of total retention time)}

\item{Q}{Numeric. Limits the Q distance between feature pairs for modeling}

\item{k}{integer k value controlling the dimension of the basis spline fit}
}
\value{
list of parameter values
}
\description{
Return a list of parameters for computing a m/z shift model
between a pair of LC-MS metabolomics data sets.
}
\details{
Correcting for systematic m/z shifts improves the scores for
feature pair alignments, yielding more accurate match hypotheses. This
function yields a parameter list for GAM spline fitting of points that
meet criteria for m/z, RT (rty vs rtProj), and Q tolerances. The number
of knots for the GAM fit is controlled by hyperparameter k.
}
\examples{

mzfit <- mzfitParam(mz = 0.003, rt = 0.05, Q = 0.2, k = 20)

}
