% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{rtData}
\alias{rtData}
\alias{rtData,metabCombiner-method}
\title{Retrieve Retention Time Values}
\usage{
rtData(object, data = NULL, value = c("obs", "mean"))

\S4method{rtData}{metabCombiner}(object, data = NULL, value = c("observed", "mean"))
}
\arguments{
\item{object}{\code{metabCombiner} object}

\item{data}{dataset identifier to extract information from; if NULL,
extracts information from all datasets}

\item{value}{Either"obs" (observed - default option) or "mean"}
}
\value{
data frame or vector of retention time values
}
\description{
This retrieves feature RT values from one or all constituent
dataset features of a \code{metabCombiner} object. Alternatively, the average
RT value can be retrieved.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")
p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##retrieve all RTs
rt <- rtData(p.comb, data = NULL)

##retrieve RTs from p30
rt <- rtData(p.comb, data = "p30")

##retrieve mean RT
rt <- rtData(p.comb, value = "mean")

}
