% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{selectAnchorsParam}
\alias{selectAnchorsParam}
\title{List selectAnchors Defaults}
\usage{
selectAnchorsParam(
  useID = FALSE,
  tolmz = 0.003,
  tolQ = 0.3,
  tolrtq = 0.3,
  windx = 0.03,
  windy = 0.03,
  brackets_ignore = c("(", "[", "{")
)
}
\arguments{
\item{useID}{Choice of using IDs for anchor selection; default: FALSE}

\item{tolmz}{m/z tolerance for ordered pair features; default: 0.003}

\item{tolQ}{Q tolerance for ordered pair features; default: 0.3}

\item{tolrtq}{RT quantile tolerance for ordered pair features; default: 0.5}

\item{windx}{X feature RT window parameter. Default: 0.03}

\item{windy}{Y feature RT window parameter. Default: 0.03}

\item{brackets_ignore}{bracket types for ignoring string comparisons}
}
\value{
list of selectAnchors parameters
}
\description{
List of default parameters for anchor selection step of main package
workflow, which can be used as input for the wrapper functions. See
help(selectAnchors) or ?selectAnchors for more details.
}
\examples{
sa_param <- selectAnchorsParam(tolmz = 0.002, tolQ = 0.2, windy = 0.02)

}
\seealso{
\code{\link{selectAnchors}}, \code{\link{metabCombine}}
}
