% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write2file.R
\name{write2file}
\alias{write2file}
\title{Print metabCombiner Report to File.}
\usage{
write2file(object, file, sep = ",")
}
\arguments{
\item{object}{\code{metabCombiner} object or \code{combinedTable}}

\item{file}{character string naming the output file path}

\item{sep}{Character field separator. Values within each row are separated
by this character.}
}
\value{
no values returned
}
\description{
Prints a \code{combinedTable} report to a file, specified by
             \code{file} argument. Output file has an empty line between
             each separate m/z group for ease of viewing.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb <- metabCombiner(xdata = p30, ydata = p20, binGap = 0.0075)

p.comb <- selectAnchors(p.comb, tolmz = 0.003, tolrtq = 0.3, windy = 0.02)
p.comb <- fit_gam(p.comb, k = 20, iterFilter = 1)
p.comb <- calcScores(p.comb, A = 90, B = 14, C = 0.5)
p.comb <- labelRows(p.comb, maxRankX = 2, maxRankY = 2, remove = TRUE)

\donttest{
###using metabCombiner object as input
write2file(p.comb, file = "plasma-combined.csv", sep = ",")

###using combinedTable report and feature data as input
cTable <- combinedTable(p.comb)
write2file(cTable, file = "plasma-combined.txt", sep = "\t")
}
}
