% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{x}
\alias{x}
\alias{xy}
\alias{y}
\alias{x,metabCombiner-method}
\alias{xy,metabCombiner-method}
\alias{y,metabCombiner-method}
\title{Obtain x & y Data Identifiers}
\usage{
x(object)

xy(object)

y(object)

\S4method{x}{metabCombiner}(object)

\S4method{xy}{metabCombiner}(object)

\S4method{y}{metabCombiner}(object)
}
\arguments{
\item{object}{\code{metabCombiner} object}
}
\value{
character X or Y dataset identifiers

data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")
p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

#expected: "p30"
x(p.comb)

#expected: "p20"
y(p.comb)

#list of x & y data descriptors
xy(p.comb)
}
\description{
\code{metabCombiner} alignment is performed in a pairwise manner
between two datasets generically termed "x" & "y". These methods print the
identifier(s) associated with datasets X and Y, contained within the xy slot
of a constructed \code{metabCombiner} object.
}
