% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R
\docType{class}
\name{methylRaw-class}
\alias{methylRaw-class}
\alias{methylRaw}
\title{An S4 class for holding raw methylation data from an alignment pipeline.}
\description{
This object stores the raw mehylation data that is read in through read 
function and extends \code{data.frame}.The raw methylation data is basically
percent methylation values and read coverage values per genomic base/region.
}
\section{Slots}{
\describe{
 \item{\code{sample.id}:}{string for an identifier of the sample}
 \item{\code{assembly}:}{string for genome assembly, ex: hg18,hg19,mm9}
 \item{\code{context}:}{ methylation context string, ex: CpG,CpH,CHH, etc.}
 \item{\code{resolution}:}{ resolution of methylation information, 'base' or 
 'region'}
                }
}

\section{Details}{

\code{methylRaw} class extends \code{\link{data.frame}} class therefore 
providing novice and experienced R users with a data structure that is well 
known and ubiquitous in many R packages.
}

\section{Subsetting}{

 In the following code snippets, \code{x} is a \code{methylRaw}.
 Subsetting by \code{x[i,]} will produce a new object if subsetting is done on
 rows. Column subsetting is not directly allowed to prevent errors in the 
 downstream analysis. see ?methylKit[ .
}

\section{Accessors}{
 
The following functions provides access to data slots of methylDiffDB:
- \code{\link{getData}}: get the data slot from the methylKit objects,
- \code{\link{getAssembly}}: get assembly of the genome,
- \code{\link{getContext}}: get the context of methylation
}

\section{Coercion}{

  \code{methylRaw} object can be coerced to 
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object via \code{\link{as}} function.
}

\examples{

# example of a raw methylation data as a text file
read.table(system.file("extdata", "control1.myCpG.txt", 
                                package = "methylKit"),
                                    header=TRUE,nrows=5)

data(methylKit)

# example of a methylRaw object
head(methylRawList.obj[[1]])
str(head(methylRawList.obj[[1]]))

library(GenomicRanges)

#coercing methylRaw object to GRanges object
my.gr=as(methylRawList.obj[[1]],"GRanges")

}
