% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionalize.R, R/methylDBFunctions.R
\docType{methods}
\name{regionCounts}
\alias{regionCounts}
\alias{regionCounts,methylRaw,GRanges-method}
\alias{regionCounts,methylBase,GRanges-method}
\alias{regionCounts,methylRaw,GRangesList-method}
\alias{regionCounts,methylBase,GRangesList-method}
\alias{regionCounts,methylRawList,GRanges-method}
\alias{regionCounts,methylRawList,GRangesList-method}
\alias{regionCounts,methylRawDB,GRanges-method}
\alias{regionCounts,methylRawDB,GRangesList-method}
\alias{regionCounts,methylRawListDB,GRanges-method}
\alias{regionCounts,methylRawListDB,GRangesList-method}
\alias{regionCounts,methylBaseDB,GRanges-method}
\alias{regionCounts,methylBaseDB,GRangesList-method}
\title{Get regional counts for given GRanges or GRangesList object}
\usage{
regionCounts(object,regions,cov.bases=0,strand.aware=FALSE,chunk.size,save.db,...)

\S4method{regionCounts}{methylRaw,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylBase,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylRaw,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylBase,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylRawList,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylRawList,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{regionCounts}{methylRawDB,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{regionCounts}{methylRawDB,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{regionCounts}{methylRawListDB,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{regionCounts}{methylRawListDB,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{regionCounts}{methylBaseDB,GRanges}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{regionCounts}{methylBaseDB,GRangesList}(
  object,
  regions,
  cov.bases = 0,
  strand.aware = FALSE,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{\link{methylRaw}}, \code{\link{methylRawDB}},
  \code{\link{methylRawList}}, \code{\link{methylRawListDB}},
  \code{\link{methylBase}} or \code{\link{methylBaseDB}} object
 
NOTE: The given regions (Granges/GrangesList object) will be orderd based on
chromosome and position before searching for overlaps, so the resulting
methylKit object might have a different ording than expected. See details
section for the reasoning of this choice and ways to still get custom
ordering of regions.}

\item{regions}{a GRanges or GRangesList object. Make sure that the GRanges
objects are
      unique in chr,start,end and strand columns.You can make them unique by 
      using unique() function.}

\item{cov.bases}{number minimum bases covered per region (Default:0). 
Only regions with base coverage above this threshold are returned.}

\item{strand.aware}{if set to TRUE only CpGs that match the strand of 
the region will be summarized. (default:FALSE)}

\item{chunk.size}{Number of rows to be taken as a chunk for processing 
the \code{methylDB} objects (default: 1e6)}

\item{save.db}{A Logical to decide whether the resulting object should be 
saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE

\code{suffix}
      A character string to append to the name of the output flat 
      file database, 
      only used if save.db is true, 
      default actions: append \dQuote{_regions} to current filename 
      if database already exists or generate new file with 
      filename \dQuote{sampleID_regions} or 
      \dQuote{methylBase_filtered} dependent on input object
      
\code{dbdir} 
      The directory where flat file database(s) should be stored, 
      defaults
      to getwd(), working directory for newly stored databases
      and to same directory for already existing database
      
\code{dbtype}
    The type of the flat file database, currently only option is "tabix"
      (only used for newly stored databases)}
}
\value{
a new methylRaw,methylBase or methylRawList object. If \code{strand.aware} is
         set to FALSE (default). Even though the resulting object will have
         the strand information of \code{regions} it will still contain 
         methylation information from both strands.
}
\description{
Convert \code{\link{methylRaw}}, \code{\link{methylRawDB}},
\code{\link{methylRawList}}, \code{\link{methylRawListDB}},
\code{\link{methylBase}} or \code{\link{methylBaseDB}}  object into regional
counts for a given \code{\link{GRanges}} or \code{\link{GRangesList}} object.
}
\section{Details}{

The given regions (Granges/GrangesList object) will be orderd based on
chromosome and position before searching for overlaps, so the resulting
methylKit object might have a different ording than expected. We are doing
this is to ensure that resulting output is consistent for in-memory and
database based objects, as database based objects always have to be sorted to
enable tabix indexing and providing fast random access. 

If you to still want get a custom ordering of the output regions you can
access the single regions in any object providing your indices to the
\code{\link{select}} or \code{\link{extract}} functions.

The parameter \code{chunk.size} is only used when working with 
\code{methylRawDB}, \code{methylBaseDB} or \code{methylRawListDB} objects, 
as they are read in chunk by chunk to enable processing large-sized objects 
which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for most 
systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the \code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as 
\code{methylRawDB}, \code{methylBaseDB} or \code{methylRawListDB}, 
while being per default FALSE for \code{methylRaw}, \code{methylBase} or
 \code{methylRawList}. If you wish to save the result of an 
in-memory-calculation as flat file database or if the size of the database 
allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{
data(methylKit)

# get the windows of interest as a GRanges object, this can be any set 
# of genomic locations
library(GenomicRanges)
my.win=GRanges(seqnames="chr21",
ranges=IRanges(start=seq(from=9764513,by=10000,length.out=20),width=5000) )

# getting counts per region
regional.methylRaw=regionCounts(object=methylRawList.obj, regions=my.win, 
cov.bases=0,strand.aware=FALSE)

}
