% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotSeries.R
\name{plotSeries}
\alias{plotSeries}
\alias{plotSeries,SummarizedExperiment-method}
\title{Plot Series}
\usage{
plotSeries(object, ...)

\S4method{plotSeries}{SummarizedExperiment}(
  object,
  x,
  y = NULL,
  rank = NULL,
  colour.by = colour_by,
  colour_by = NULL,
  size.by = size_by,
  size_by = NULL,
  linetype.by = linetype_by,
  linetype_by = NULL,
  assay.type = assay_name,
  assay_name = "counts",
  ...
)
}
\arguments{
\item{object}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{additional parameters for plotting. See
\code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}

\item{x}{\code{Character scalar}. selecting the column from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{ColData}} that
will specify values of x-axis.}

\item{y}{\code{Character scalar}. Selects the taxa from
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{rownames}}.
This parameter specifies taxa whose abundances will be plotted.}

\item{rank}{\code{Character scalar}. A taxonomic rank, that is used
to agglomerate the data. Must be a value of \code{taxonomicRanks()}
function. (Default: \code{NULL})}

\item{colour.by}{\code{Character scalar}. A taxonomic rank, that is used to
color plot. Must be a value of \code{taxonomicRanks()} function.
(Default: \code{NULL})}

\item{colour_by}{Deprecated. Use \code{colour.by} instead.}

\item{size.by}{\code{Character scalar}. A taxonomic rank, that is
used to divide taxa to different line size types. Must be a value of
\code{taxonomicRanks()} function. (Default: \code{NULL})}

\item{size_by}{Deprecated. Use \code{size.by} instead.}

\item{linetype.by}{\code{Character scalar}. A taxonomic rank, that
is used to divide taxa to different line types. Must be a value of
\code{taxonomicRanks()} function. (Default: \code{NULL})}

\item{linetype_by}{Deprecated. Use \code{linetype.by} instead.}

\item{assay.type}{\code{Character scalar}. selecting the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{assay}} to be
plotted. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}
}
\value{
A \code{ggplot2} object
}
\description{
This function plots series data.
}
\details{
This function creates series plot, where x-axis includes e.g. time points,
and y-axis abundances of selected taxa.
}
\examples{
\dontrun{
library(mia)
# Load data from miaTime package
library("miaTime")
data(SilvermanAGutData)
object <- SilvermanAGutData

# Plots 2 most abundant taxa, which are colored by their family
plotSeries(object,
           x = "DAY_ORDER",
           y = getTop(object, 2),
           colour.by = "Family")

# Counts relative abundances
object <- transformAssay(object, method = "relabundance")

# Selects taxa
taxa <- c("seq_1", "seq_2", "seq_3", "seq_4", "seq_5")

# Plots relative abundances of phylums
plotSeries(object[taxa,],
           x = "DAY_ORDER",
           colour.by = "Family",
           linetype.by = "Phylum",
           assay.type = "relabundance")

# In addition to 'colour.by' and 'linetype.by', 'size.by' can also be used
# to group taxa.
plotSeries(object,
           x = "DAY_ORDER",
           y = getTop(object, 5),
           colour.by = "Family",
           size.by = "Phylum",
           assay.type = "counts")
}
}
\author{
Leo Lahti and Tuomas Borman. Contact: \url{microbiome.github.io}
}
