% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotTree.R
\name{plotRowTree}
\alias{plotRowTree}
\alias{plotColTree}
\alias{plotTree}
\alias{plotColTree,TreeSummarizedExperiment-method}
\alias{plotRowTree,TreeSummarizedExperiment-method}
\title{Plotting tree information enriched with information}
\usage{
plotRowTree(x, ...)

plotColTree(x, ...)

\S4method{plotColTree}{TreeSummarizedExperiment}(
  x,
  tree.name = tree_name,
  tree_name = "phylo",
  relabel.tree = relabel_tree,
  relabel_tree = FALSE,
  order.tree = order_tree,
  order_tree = FALSE,
  levels.rm = remove_levels,
  remove_levels = FALSE,
  show.label = show_label,
  show_label = FALSE,
  show.highlights = show_highlights,
  show_highlights = FALSE,
  show.highlight.label = show_highlight_label,
  show_highlight_label = FALSE,
  abbr.label = abbr_label,
  abbr_label = FALSE,
  add.legend = add_legend,
  add_legend = TRUE,
  layout = "circular",
  edge.colour.by = edge.colour.by,
  edge_colour_by = NULL,
  edge.size.by = edge_size_by,
  edge_size_by = NULL,
  tip.colour.by = tip_colour_by,
  tip_colour_by = NULL,
  tip.shape.by = tip_shape_by,
  tip_shape_by = NULL,
  tip.size.by = tip_size_by,
  tip_size_by = NULL,
  node.colour.by = node_colour_by,
  node_colour_by = NULL,
  node.shape.by = node_shape_by,
  node_shape_by = NULL,
  node.size.by = node_size_by,
  node_size_by = NULL,
  colour.highlights.by = colour_highlights_by,
  colour_highlights_by = NULL,
  assay.type = by_exprs_values,
  by_exprs_values = "counts",
  other.fields = other_fields,
  other_fields = list(),
  ...
)

\S4method{plotRowTree}{TreeSummarizedExperiment}(
  x,
  tree.name = tree_name,
  tree_name = "phylo",
  relabel.tree = relabel_tree,
  relabel_tree = FALSE,
  order.tree = order_tree,
  order_tree = FALSE,
  levels.rm = remove_levels,
  remove_levels = FALSE,
  show.label = show_label,
  show_label = FALSE,
  show.highlights = show_highlights,
  show_highlights = FALSE,
  show.highlight.label = show_highlight_label,
  show_highlight_label = FALSE,
  abbr.label = abbr_label,
  abbr_label = FALSE,
  add.legend = add_legend,
  add_legend = TRUE,
  layout = "circular",
  edge.colour.by = edge_colour_by,
  edge_colour_by = NULL,
  edge.size.by = edge_size_by,
  edge_size_by = NULL,
  tip.colour.by = tip_colour_by,
  tip_colour_by = NULL,
  tip.shape.by = tip_shape_by,
  tip_shape_by = NULL,
  tip.size.by = tip_size_by,
  tip_size_by = NULL,
  node.colour.by = node_colour_by,
  node_colour_by = NULL,
  node.shape.by = node_shape_by,
  node_shape_by = NULL,
  node.size.by = node_size_by,
  node_size_by = NULL,
  colour.highlights.by = colour_highlights_by,
  colour_highlights_by = NULL,
  assay.type = by_exprs_values,
  by_exprs_values = "counts",
  other.fields = other_fields,
  other_fields = list(),
  ...
)
}
\arguments{
\item{x}{a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments for plotting. See
\code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}

\item{tree.name}{\code{Character scalar}. Specifies a rowTree/colTree from
\code{x}. (Default: \code{tree.name = "phylo"})}

\item{tree_name}{Deprecated. Use \code{tree.name} instead.}

\item{relabel.tree}{\code{Logical scalar}. Should the tip labels be relabeled
using the output of \code{getTaxonomyLabels(x, with_rank = TRUE)}?
(Default: \code{FALSE})}

\item{relabel_tree}{Deprecated. Use \code{relavel.tree} instead.}

\item{order.tree}{\code{Logical scalar}. Should the tree be ordered based on
alphabetic order of taxonomic levels? (Default: \code{FALSE})}

\item{order_tree}{Deprecated. Use \code{order.tree} instead.}

\item{levels.rm}{\code{Logical scalar}. Should taxonomic level information
be removed from labels? (Default: \code{FALSE})}

\item{remove_levels}{Deprecated. Use \code{levels.rm} instead.}

\item{show.label, show.highlights, show.highlight.label, abbr.label}{\code{logical} (scalar), \code{integer} or \code{character} vector. If a
\code{logical} scalar is given, should tip labels be plotted or if a
logical vector is provided, which labels should be shown? If an
\code{integer} or \code{character} vector is provided, it will be converted
to a logical vector. The \code{integer} values must be in the range of 1
and number of nodes, whereas the values of a \code{character} vector must
match values of the \code{label} column in the node data. In case of a
\code{character} vector only values corresponding to actual labels will be
plotted and if no labels are provided no labels will be shown. (Default:
\code{FALSE})}

\item{show_label, show_highlights, show_highlight_label, abbr_label}{Deprecated.
Use \code{show.label, show.highlights, show.highlight.label, abbr_label}
instead.}

\item{add.legend}{\code{Logical scalar}. Should legends be plotted?
(Default: \code{TRUE})}

\item{add_legend}{Deprecated. Use \code{add.legend} instead.}

\item{layout}{layout for the plotted tree. See
\code{\link[ggtree:ggtree]{ggtree}} for details.}

\item{edge.colour.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to colour tree edges by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values.}

\item{edge_colour_by}{Deprecated. Use \code{edge.colour.by} instead.}

\item{edge.size.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to size tree edges by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{edge_size_by}{Deprecated. Use \code{edge.size.by} instead.}

\item{tip.colour.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to colour tree tips by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{tip_colour_by}{Deprecated. Use \code{tip.colour.by} instead.}

\item{tip.shape.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to shape tree tips by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{tip_shape_by}{Deprecated. Use \code{tip.shape.by} isntead.}

\item{tip.size.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to size tree tips by, see the by argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}} for possible
values. (Default: \code{NULL})}

\item{tip_size_by}{Deprecated. Use \code{tip.size.by} instead.}

\item{node.colour.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to colour tree nodes by. Must be a field from
\code{other.fields}. (Default: \code{NULL})}

\item{node_colour_by}{Deprecated. Use \code{node.colour.by} instead.}

\item{node.shape.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to shape tree nodes by. Must be a field from
\code{other.fields}. (Default: \code{NULL})}

\item{node_shape_by}{Deprecated. Use \code{node.shape.by} instead.}

\item{node.size.by}{\code{Character scalar}. Specification of a column
metadata field or a feature to size tree nodes by. Must be a field from
\code{other.fields}. (Default: \code{NULL})}

\item{node_size_by}{Deprecated. Use \code{node.size.by} instead.}

\item{colour.highlights.by}{\code{Logical scalar}. Should the highlights be
colour differently? If \code{show.highlights = TRUE},
\code{colour_highlights} will be set to \code{TRUE} as default.
(Default: \code{FALSE})}

\item{colour_highlights_by}{Deprecated. Use \code{colour.highlights.by}
instead.}

\item{assay.type}{\code{Character scalar}. or \code{integer scalar}.
Specifies which assay to obtain expression values from, for use in point
aesthetics - see the \code{exprs_values} argument in
\code{\link[scater:retrieveCellInfo]{?retrieveCellInfo}}.
(Default: \code{"counts"})}

\item{by_exprs_values}{Deprecated. Use \code{assay.type} instead.}

\item{other.fields}{\code{Character vector}. Additional fields to include in
the node information without plotting them. (Default: \code{list()})}

\item{other_fields}{Deprecated. Use \code{other.fields} instead.}
}
\value{
a \code{\link{ggtree}} plot
}
\description{
Based on the stored data in a \code{TreeSummarizedExperiment} a tree can
be plotted. From the \code{rowData}, the \code{assays} as well as the
\code{colData} information can be taken for enriching the tree plots with
additional information.
}
\details{
If \code{show.label} or \code{show.highlight.label} have the same length
as the number of nodes, the vector will be used to relabel the nodes.
}
\examples{
library(scater)
library(mia)
# preparation of some data
data(GlobalPatterns)
GlobalPatterns <- agglomerateByRanks(GlobalPatterns)
altExp(GlobalPatterns,"Genus") <- addPerFeatureQC(
  altExp(GlobalPatterns,"Genus"))
rowData(altExp(GlobalPatterns,"Genus"))$log_mean <-
  log(rowData(altExp(GlobalPatterns,"Genus"))$mean)
rowData(altExp(GlobalPatterns,"Genus"))$detected <-
   rowData(altExp(GlobalPatterns,"Genus"))$detected / 100
top_genus <- getTop(altExp(GlobalPatterns,"Genus"),
                        method="mean",
                        top=100L,
                        assay.type="counts")
#
x <- altExp(GlobalPatterns,"Genus")
plotRowTree(x[rownames(x) \%in\% top_genus,],
            tip.colour.by = "log_mean",
            tip.size.by = "detected")

# plot with tip labels
plotRowTree(x[rownames(x) \%in\% top_genus,],
            tip.colour.by = "log_mean",
            tip.size.by = "detected",
            show.label = TRUE)
# plot with selected labels
labels <- c("Genus:Providencia", "Genus:Morganella", "0.961.60")
plotRowTree(x[rownames(x) \%in\% top_genus,],
            tip.colour.by = "log_mean",
            tip.size.by = "detected",
            show.label = labels,
            layout="rectangular")

# plot with labeled edges
plotRowTree(x[rownames(x) \%in\% top_genus,],
            edge.colour.by = "Phylum",
            tip.colour.by = "log_mean")
# if edges are sized, colours might disappear depending on plotting device
plotRowTree(x[rownames(x) \%in\% top_genus,],
            edge.colour.by = "Phylum",
            edge.size.by = "detected",
            tip.colour.by = "log_mean")

# aggregating data over the taxonomic levels for plotting a taxonomic tree
# please note that the original tree of GlobalPatterns is dropped by
# unsplitByRanks
altExps(GlobalPatterns) <- splitByRanks(GlobalPatterns)
top_phyla <- getTop(altExp(GlobalPatterns,"Phylum"),
                        method="mean",
                        top=10L,
                        assay.type="counts")
altExps(GlobalPatterns) <- lapply(altExps(GlobalPatterns), addPerFeatureQC)
altExps(GlobalPatterns) <-
   lapply(altExps(GlobalPatterns),
          function(y){
              rowData(y)$log_mean <- log(rowData(y)$mean)
              rowData(y)$detected <- rowData(y)$detected / 100
              y
          })
x <- unsplitByRanks(GlobalPatterns)
x <- addHierarchyTree(x)

highlights <- c("Phylum:Firmicutes","Phylum:Bacteroidetes",
                "Family:Pseudomonadaceae","Order:Bifidobacteriales")
plotRowTree(x[rowData(x)$Phylum \%in\% top_phyla,],
            tip.colour.by = "log_mean",
            node.colour.by = "log_mean",
            show.highlights = highlights,
            show.highlight.label = highlights,
            colour.highlights.by = "Phylum")

plotRowTree(x[rowData(x)$Phylum \%in\% top_phyla,],
            edge.colour.by = "Phylum",
            edge.size.by = "detected",
            tip.colour.by = "log_mean",
            node.colour.by = "log_mean")
}
\seealso{
\code{\link[mia:agglomerate-methods]{agglomerateByRanks}}
}
