% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_and_plot.R
\name{mitoHeatmap}
\alias{mitoHeatmap}
\title{Heatmap of mitochondrial gene sets.}
\usage{
mitoHeatmap(
  data,
  database = "MitoCarta",
  sampleAnnot = NULL,
  splitSamples = FALSE,
  splitSections = FALSE,
  ...
)
}
\arguments{
\item{data}{matrix or data.frame with samples in columns and mitochondrial 
gene sets in rows.}

\item{database}{character string saying the database used for the analysis.
Either one of "MitoCarta", "Reactome", "GO-CC" and "GO-BP".}

\item{sampleAnnot}{character vector with samples' annotation.}

\item{splitSamples}{logical. If TRUE it splits samples by annotation. 
sampleAnnot must be provided.}

\item{splitSections}{logical. If TRUE it splits gene sets by main section.}

\item{...}{other parameters specific of the function
\code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
A \code{\link[ComplexHeatmap]{Heatmap-class}} object.
}
\description{
Given a matrix of scores, it returns a heatmap of
the mitochondrial gene sets.
}
\examples{
MClist <- getGeneSets()
n <- length(names(MClist)) * 5
rmatrix <- matrix(rnorm(n, 0), ncol = 5)
rownames(rmatrix) <- names(MClist)
colnames(rmatrix) <- paste0("Sample_", seq_len(5))
mitoHeatmap(data = rmatrix, database = "MitoCarta")

}
