% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTest-methods.R
\name{hypothesisTest,SummarizedExperiment-method}
\alias{hypothesisTest,SummarizedExperiment-method}
\alias{hypothesisTest}
\alias{hypothesisTest,QFeatures-method}
\alias{hypothesisTestHurdle}
\alias{hypothesisTestHurdle,SummarizedExperiment-method}
\alias{hypothesisTestHurdle,QFeatures-method}
\title{Parameter estimates, standard errors and statistical inference on differential
expression analysis}
\usage{
\S4method{hypothesisTest}{SummarizedExperiment}(
  object,
  contrast,
  adjust.method = "BH",
  modelColumn = "msqrobModels",
  resultsColumnNamePrefix = "",
  overwrite = FALSE
)

\S4method{hypothesisTestHurdle}{SummarizedExperiment}(
  object,
  contrast,
  adjust.method = "BH",
  modelColumn = "msqrobHurdle",
  resultsColumnNamePrefix = "hurdle_",
  overwrite = FALSE
)

\S4method{hypothesisTest}{QFeatures}(
  object,
  i,
  contrast,
  adjust.method = "BH",
  modelColumn = "msqrobModels",
  resultsColumnNamePrefix = "",
  overwrite = FALSE
)

\S4method{hypothesisTestHurdle}{QFeatures}(
  object,
  i,
  contrast,
  adjust.method = "BH",
  modelColumn = "msqrobHurdle",
  resultsColumnNamePrefix = "hurdle_",
  overwrite = FALSE
)
}
\arguments{
\item{object}{\code{SummarizedExperiment} or \code{QFeatures} instance}

\item{contrast}{\code{numeric} matrix specifying one or more contrasts of
the linear model coefficients to be tested equal to zero. If multiple
contrasts are given (multiple columns) then results will be returned for
each contrast. The rownames of the matrix should be equal to the names
of parameters of the model that are involved in the contrast.
The column names of the matrix will be used to construct names to store
the results in the rowData of the SummarizedExperiment or of the assay of
the QFeatures object. The contrast matrix can be made using the \code{makeContrast}
function.}

\item{adjust.method}{\code{character} specifying the method to adjust
the p-values for multiple testing.
Options, in increasing conservatism, include ‘"none"’,
‘"BH"’, ‘"BY"’ and ‘"holm"’.  See ‘p.adjust’ for the complete
list of options. Default is "BH" the Benjamini-Hochberg method
to controle the False Discovery Rate (FDR).}

\item{modelColumn}{\code{character} to indicate the variable name that was used
to store the msqrob models in the rowData of the SummarizedExperiment
instance or of the assay of the QFeatures instance. Default is "msqrobModels"
when the \code{hypothesisTest} function is used and "msqrobHurdle" for \code{hypothesisTestHurdle}.}

\item{resultsColumnNamePrefix}{\code{character} to indicate the the prefix for the
variable name that will be used to store test results in the rowData of
the SummarizedExperiment instance or of the assay of the QFeatures instance.
Default is "" so that the variable name with the results will be
the column name of the column in the contrast matrix L. If L is a matrix
with multiple columns, multiple results columns will be made, one for each
contrast. If L is a matrix with a single column which has no column names and if resultsColumnNamePrefix="" the
results will be stored in the column with name msqrobResults. For hypothesisTestHurdle
the default prefix is "hurdle_". If L is a matrix with one column and has no column names and if resultsColumnNamePrefix="hurdle_" the
results will be stored in the column with name hurdleResults.}

\item{overwrite}{\code{boolean(1)} to indicate if the column in the rowData has to
be overwritten if the modelColumnName already exists. Default is FALSE.}

\item{i}{\code{character} or \code{integer} to specify the element of the \code{QFeatures} that
contains the log expression intensities that will be modelled.}
}
\value{
A SummarizedExperiment or a \code{QFeatures} instance augmented with the test
results.
}
\description{
Summary table of the estimates for differential expression of features
}
\examples{

# Load example data
# The data are a Feature object containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")

# Fit msqrob model
pe <- msqrob(pe, i = "protein", formula = ~condition)

# Define contrast
getCoef(rowData(pe[["protein"]])$msqrobModels[[1]])
# Assess log2 fold change between condition c and condition b
L <- makeContrast(
    "conditionc - conditionb=0",
    c("conditionb", "conditionc")
)

# example SummarizedExperiment instance
se <- pe[["protein"]]
se <- hypothesisTest(se, L)
head(rowData(se)$"conditionc - conditionb", 10)
# Volcano plot
plot(-log10(pval) ~ logFC,
    rowData(se)$"conditionc - conditionb",
    col = (adjPval < 0.05) + 1
)

# Example for QFeatures instance
# Assess log2 fold change between condition b and condition a (reference class),
# condition c and condition a, and, condition c and condition b.
L <- makeContrast(
    c(
        "conditionb=0",
        "conditionc=0",
        "conditionc - conditionb=0"
    ),
    c("conditionb", "conditionc")
)
pe <- hypothesisTest(pe, i = "protein", L)
head(rowData(pe[["protein"]])$"conditionb", 10)
# Volcano plots
par(mfrow = c(1, 3))
plot(-log10(pval) ~ logFC,
    rowData(pe[["protein"]])$"conditionb",
    col = (adjPval < 0.05) + 1,
    main = "log2 FC b-a"
)
plot(-log10(pval) ~ logFC,
    rowData(pe[["protein"]])$"conditionc",
    col = (adjPval < 0.05) + 1,
    main = "log2 FC c-a"
)
plot(-log10(pval) ~ logFC,
    rowData(pe[["protein"]])$"conditionc - conditionb",
    col = (adjPval < 0.05) + 1,
    main = "log2 FC c-b"
)

# Hurdle method
pe <- msqrobHurdle(pe, i = "protein", formula = ~condition)
pe <- hypothesisTestHurdle(pe, i = "protein", L)
head(rowData(pe[["protein"]])$"hurdle_conditionb", 10)
}
\author{
Lieven Clement
}
