% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msqrob-methods.R
\name{msqrob,SummarizedExperiment-method}
\alias{msqrob,SummarizedExperiment-method}
\alias{msqrob}
\alias{msqrob,QFeatures-method}
\title{Methods to fit msqrob models with ridge regression and/or random effects using lme4}
\usage{
\S4method{msqrob}{SummarizedExperiment}(
  object,
  formula,
  modelColumnName = "msqrobModels",
  overwrite = FALSE,
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE))
)

\S4method{msqrob}{QFeatures}(
  object,
  i,
  formula,
  modelColumnName = "msqrobModels",
  overwrite = FALSE,
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE))
)
}
\arguments{
\item{object}{\code{SummarizedExperiment} or \code{QFeatures} instance}

\item{formula}{Model formula. The model is built based on the
covariates in the data object.}

\item{modelColumnName}{\code{character} to indicate the variable name that is used
to store the msqrob models in the rowData of the SummarizedExperiment
instance or of the assay of the QFeatures instance. Default is "msqrobModels".}

\item{overwrite}{\code{boolean(1)} to indicate if the column in the rowData has to
be overwritten if the modelColumnName already exists. Default is FALSE.}

\item{robust}{\code{boolean(1)} to indicate if robust regression is
performed to account for outliers. Default is \code{TRUE}. If
\code{FALSE} an OLS fit is performed.}

\item{ridge}{\code{boolean(1)} to indicate if ridge regression is
performed. Default is \code{FALSE}. If \code{TRUE} the fixed effects are
estimated via penalized regression and shrunken to zero.}

\item{maxitRob}{\code{numeric(1)} indicating the maximum iterations in
the IRWLS algorithm used in the M-estimation step of the robust
regression.}

\item{tol}{\code{numeric(1)} indicating the tolerance for declaring convergence
of the M-estimation loop.}

\item{doQR}{\code{boolean(1)} to indicate if QR decomposition is used when adopting
ridge regression. Default is \code{TRUE}. If \code{FALSE} the predictors of the fixed
effects are not transformed, and the degree of shrinkage can depend on the encoding.}

\item{lmerArgs}{a list (of correct class, resulting from ‘lmerControl()’
containing control parameters, including the nonlinear optimizer to be used
and parameters to be passed through to the nonlinear optimizer, see the
‘lmerControl’ documentation of the lme4 package for more details.
Default is \code{list(control = lmerControl(calc.derivs = FALSE))}}

\item{i}{\code{character} or \code{integer} to specify the element of the \code{QFeatures} that
contains the log expression intensities that will be modelled.}
}
\value{
A SummarizedExperiment or a \code{QFeatures} instance with the models.
}
\description{
Parameter estimation of msqrob models for \code{QFeatures}
and \code{SummarizedExperiment} instance.
}
\examples{

# Load example data
# The data are a Feature object with containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")

# Fit MSqrob model using robust linear regression upon summarization of
# peptide intensities into protein expression values.
# For summarized SummarizedExperiment
se <- pe[["protein"]]
se
colData(se) <- colData(pe)
se <- msqrob(se, formula = ~condition, modelColumnName = "rlm")
getCoef(rowData(se)$rlm[[1]])

# For features object
pe <- msqrob(pe, i = "protein", formula = ~condition, modelColumnName = "rlm")
# with ridge regression (slower)
pe <- msqrob(pe, i = "protein", formula = ~condition, ridge = TRUE, modelColumnName = "ridge")

# compare for human protein (no DE)==> large shrinkage to zero
cbind(getCoef(rowData(pe[["protein"]])$rlm[[1]]), getCoef(rowData(pe[["protein"]])$ridge[[1]]))

# compare for ecoli protein (DE)==> almost no shrinkage to zero
cbind(
    getCoef(rowData(pe[["protein"]])$rlm[["P00956"]]),
    getCoef(rowData(pe[["protein"]])$ridge[["P00956"]])
)
}
\author{
Lieven Clement
}
