% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msqrobAggregate.R
\name{msqrobAggregate,SummarizedExperiment-method}
\alias{msqrobAggregate,SummarizedExperiment-method}
\alias{msqrobAggregate}
\alias{msqrobAggregate,QFeatures-method}
\title{Method to fit msqrob models with robust regression and/or ridge regression and/or random effects
It models multiple features simultaneously, e.g. multiple peptides from the same protein.}
\usage{
\S4method{msqrobAggregate}{SummarizedExperiment}(
  object,
  formula,
  fcol,
  aggregateFun = MsCoreUtils::robustSummary,
  modelColumnName = "msqrobModels",
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE))
)

\S4method{msqrobAggregate}{QFeatures}(
  object,
  formula,
  i,
  fcol,
  name = "msqrobAggregate",
  aggregateFun = MsCoreUtils::robustSummary,
  modelColumnName = "msqrobModels",
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE))
)
}
\arguments{
\item{object}{\code{QFeatures} instance}

\item{formula}{Model formula. The model is built based on the
covariates in the data object.}

\item{fcol}{The feature variable of assay ‘i’ defining how to summarise
the features.}

\item{aggregateFun}{A function used for quantitative feature aggregation.
Details can be found in the documentation of the \code{aggregateFeatures}
of the \code{QFeatures} package.}

\item{modelColumnName}{\code{character} to indicate the variable name that is used
to store the msqrob models in the rowData of the SummarizedExperiment
instance or of the assay of the QFeatures instance. Default is "msqrobModels".}

\item{robust}{\code{boolean(1)} to indicate if robust regression is
performed to account for outliers. Default is \code{TRUE}. If
\code{FALSE} an OLS fit is performed.}

\item{ridge}{\code{boolean(1)} to indicate if ridge regression is
performed. Default is \code{FALSE}. If \code{TRUE} the fixed effects are
estimated via penalized regression and shrunken to zero.}

\item{maxitRob}{\code{numeric(1)} indicating the maximum iterations in
the IRWLS algorithm used in the M-estimation step of the robust
regression.}

\item{tol}{\code{numeric(1)} indicating the tolerance for declaring convergence
of the M-estimation loop.}

\item{doQR}{\code{boolean(1)} to indicate if QR decomposition is used when adopting
ridge regression. Default is \code{TRUE}. If \code{FALSE} the predictors of the fixed
effects are not transformed, and the degree of shrinkage can depend on the encoding.}

\item{lmerArgs}{a list (of correct class, resulting from ‘lmerControl()’
containing control parameters, including the nonlinear optimizer to be used
and parameters to be passed through to the nonlinear optimizer, see the
‘lmerControl’ documentation of the lme4 package for more details.
Default is \code{list(control = lmerControl(calc.derivs = FALSE))}}

\item{i}{\code{character} or \code{integer} to specify the element of the \code{QFeatures} that
contains the log expression intensities that will be modelled.}

\item{name}{A ‘character(1)’ naming the new assay. Default is ‘newAssay’.
Note that the function will fail if there's already an assay
with ‘name’.}
}
\value{
A ‘QFeatures’ object with an additional assay.
}
\description{
Parameter estimation of msqrob models for \code{QFeatures}instance.
The method aggregates features within the model e.g. from peptides to proteins.
It provides fold change estimates and their associated uncertainty at the aggregated
level (e.g. protein level) while correcting for the peptide species that are observed
in each sample. It also addresses the correlation in the data, e.g. the peptide data
for the same protein in a sample are correlate because they originate from the same
protein pool. The method however does not return aggregated expression values for each sample.
For visualisation purposes aggregated expression values are provide by the \code{aggregateFeatures}
function from the \code{QFeatures} Package
}
\examples{
# Load example data
# The data are a Feature object with containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Fit MSqrob model using robust ridge regression starting from peptide intensities
# The fold changes are calculated at the protein level while correcting for
# the different peptide species in each sample and the correlation between
# peptide intensities of peptides of the same protein in the same sample.
colData(pe)$samples <- rownames(colData(pe))
pe <- msqrobAggregate(pe, i = "peptide", fcol = "Proteins",
     formula = ~condition + (1|samples) + (1|Sequence),
     ridge = TRUE)
getCoef(rowData(pe[["msqrobAggregate"]])$msqrobModels[["P00956"]])

## Same but on a SummarizedExperiment object
se <- getWithColData(pe, "peptide")
se <- msqrobAggregate(se, fcol = "Proteins",
                      formula = ~condition + (1|samples) + (1|Sequence),
                      ridge = TRUE)
getCoef(rowData(se)$msqrobModels[["P00956"]])

}
\author{
Lieven Clement
}
