% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msqrob.R
\name{msqrobLm}
\alias{msqrobLm}
\title{Function to fit msqrob models using lm and rlm}
\usage{
msqrobLm(y, formula, data, robust = TRUE, maxitRob = 5)
}
\arguments{
\item{y}{A \code{matrix} with the quantified feature intensities. The
features are along the rows and samples along the columns.}

\item{formula}{Model formula. The model is built based on the
covariates in the data object.}

\item{data}{A \code{DataFrame} with information on the design. It has
the same number of rows as the number of columns (samples) of
\code{y}.}

\item{robust}{\code{boolean(1)} to indicate if robust regression is
performed to account for outliers. Default is \code{TRUE}. If
\code{FALSE} an OLS fit is performed.}

\item{maxitRob}{\code{numeric(1)} indicating the maximum iterations in
the IRWLS algorithm used in the M-estimation step of the robust
regression.}
}
\value{
A list of objects of the \code{StatModel} class.
}
\description{
Low-level function for parameter estimation with msqrob
using the ordinary least squares or robust regression
base on the MASS::rlm function.
}
\examples{

# Load example data
# The data are a Feature object with containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Aggregate peptide intensities in protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")
pe

# Fit MSqrob model using robust regression with the MASS rlm function
models <- msqrobLm(assay(pe[["protein"]]), ~condition, colData(pe))
#' getCoef(models[[1]])
}
\author{
Lieven Clement, Oliver M. Crook
}
