% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery_prediction.R
\name{predict_exposure}
\alias{predict_exposure}
\title{Prediction of exposures in new samples using pre-existing signatures}
\usage{
predict_exposure(
  musica,
  modality,
  signature_res,
  algorithm = c("lda", "decompTumor2Sig"),
  result_name = "result",
  model_id = NULL,
  signatures_to_use = seq_len(ncol(signatures(signature_res))),
  verbose = FALSE,
  make_copy = FALSE,
  table_name = NULL
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{modality}{Modality for posterior prediction. Must match the table type
used to generate the prediction signatures}

\item{signature_res}{Signatures used to predict exposures for the samples
\code{musica} object. Existing signatures need to stored in a
\code{\linkS4class{result_model}} object.}

\item{algorithm}{Algorithm to use for prediction of exposures. One of
\code{"lda"} or \code{"decompTumor2Sig"}.}

\item{result_name}{Name for result_list entry to save the results to. Default
\code{"result"}.}

\item{model_id}{Identifier for the result. If \code{NULL}, will be
automatically set to the algorithm and number of signatures. Default
\code{NULL}.}

\item{signatures_to_use}{Which signatures in the \code{signature_res} result
object to use. Default is to use all signatures.}

\item{verbose}{If \code{TRUE}, progress will be printing. Only used if
\code{algorithm = "lda"}. Default \code{FALSE}.}

\item{make_copy}{If \code{FALSE}, the inputted \code{\linkS4class{musica}}
object is updated and nothing is returned. If \code{TRUE}, a new
\code{\linkS4class{musica}} object is created and returned. Default
\code{FALSE}.}

\item{table_name}{Use modality instead}
}
\value{
Returns nothing or a new \code{\linkS4class{musica}} object,
depending on the \code{make_copy} parameter.
}
\description{
Exposures for samples will be predicted using an existing set
of signatures stored in a \code{\linkS4class{result_model}} object.
Algorithms available for prediction include a modify version of \code{"lda"},
and \code{"decompTumor2Sig"}.
}
\examples{
data(musica)
data(cosmic_v2_sigs)
g <- select_genome("19")
build_standard_table(musica, g, "SBS96", overwrite = TRUE)
result <- predict_exposure(
  musica = musica, modality = "SBS96",
  signature_res = cosmic_v2_sigs, algorithm = "lda"
)

# Predict using LDA-like algorithm with seed set to 1
set.seed(1)
predict_exposure(
  musica = musica, modality = "SBS96",
  signature_res = cosmic_v2_sigs, algorithm = "lda"
)
}
