% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{BamBigwig_to_chipProfile}
\alias{BamBigwig_to_chipProfile}
\title{BamBigwig_to_chipProfile}
\usage{
BamBigwig_to_chipProfile(
  signalFiles,
  testRanges,
  format,
  style = "percentOfRegion",
  nOfWindows = 100,
  bin_size = 20,
  distanceAround = NULL,
  distanceUp = 1000,
  distanceDown = 1000,
  ...,
  quant_params = NULL
)
}
\arguments{
\item{signalFiles}{paths to either BAM files or bigwig files. More than one path can be in this character vector, but all paths in one function call must point to be either all BAM files or all bigWig files, not a combination of the two.}

\item{testRanges}{A character vector with paths to BED files.}

\item{format}{character string of "bam", "bigwig", "RleList" or "PWM"}

\item{style}{a character string, "percentOfRegion" (default) for normalized length divided into bins set by the 'nOfWindows' argument, "point" for per base pair plot where the number of base pairs per bin is set by the 'bin_size' argument, and "region" for combined plot}

\item{nOfWindows}{The number of windows/bins the normalised ranges will be divided into if 'style' is set to 'percentOfRegion'. Default is 100.}

\item{bin_size}{If 'style' is set to 'point' then this will determine the size of each bin over which signal is quantified. The default is 20 base pairs.}

\item{distanceAround}{This controls the distance around the region that is included. If 'style' is 'percentOfRegion', then the default is 100, meaning that a distance equal to 100 percent of that particular region on either side of the region will be included in the heatmap. If 'style' is 'point',then this is the number of basepairs from the center of each range, in either direction, that the heatmap will show. If style is 'point' and 'distanceAround' is NULL, then distanceUp and distanceDown will be used.}

\item{distanceUp}{If 'style' is set to 'point' then this will determine the distance (in base pairs) upstream from the center of each peak signal will be quantified. If the 'distanceAround' argument is set (i.e. not NULL), that will be used for the quantification range and 'distanceUp will be ignored.}

\item{distanceDown}{If 'style' is set to 'point' then this will determine the distance (in base pairs) downstream from the center of each peak signal will be quantified. If the 'distanceAround' argument is set (i.e. not NULL), that will be used for the quantification range and 'distanceDown' will be ignored.}

\item{...}{pass to regionPlot() within the soGGi package}

\item{quant_params}{An optional \code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}} instance determining the parallel back-end to be used during evaluation. When this argument is set to NULL (default) SerialParam() will be used. For parallelization, MulticoreParam() can be used.}
}
\value{
A profileplyr object
}
\description{
Generate a soGGi ChIPprofile object with multiple BAM/bigWig files or multiple BED files as the input
}
\examples{
signalFiles <- c(system.file("extdata",
                             "Sorted_Hindbrain_day_12_1_filtered.bam",
                              package = "profileplyr"))
require(Rsamtools)
for (i in seq_along(signalFiles)){
 indexBam(signalFiles[i])
}
testRanges <- system.file("extdata", 
                          "newranges_small.bed", 
                          package = "profileplyr")
BamBigwig_to_chipProfile(signalFiles, 
                         testRanges, 
                         format = "bam",
                         paired=FALSE,
                         style="percentOfRegion",
                         )
}
