% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\name{generateProfilePlot}
\alias{generateProfilePlot}
\title{Import ChIPprofile object to profileplyr}
\usage{
generateProfilePlot(
  object,
  sampleNames = rownames(sampleData(object)),
  colorGroup = params(object)$rowGroupsInUse,
  colorlist = NULL,
  facet_nrow = 1,
  facet_ncol = NULL,
  facet_scales = "fixed"
)
}
\arguments{
\item{object}{A profileplyr object}

\item{sampleNames}{The names used to label the samples in the profileplyr object. By default, the names stored in rownames(sampleData(object)) are used.}

\item{colorGroup}{The name of the column in mcols(object) that will be used for color grouping in the plot. By default the column name in params(object)$rowGroupsInUse is used. If this column is not a factor variable, then it will be converted into one.}

\item{colorlist}{A vector containing the colors to be used. The positions in the vector will be matched with the levels of the factor variable chosen in the 'colorGroup' argument.}

\item{facet_nrow}{The number of rows when making the plot panels. This argument is passed to 'nrow' of the ggplot2 function \code{\link[ggplot2]{facet_wrap}}.}

\item{facet_ncol}{The number of columns when making the plot panels. This argument is passed to 'ncol' of the ggplot2 function \code{\link[ggplot2]{facet_wrap}}.}

\item{facet_scales}{Whether the scales of all plot panels should be fixed ("fixed", default), free ("free"), or free in one dimension ("free_x" or "free_y"). This argument is passed to 'scales' of the ggplot2 function \code{\link[ggplot2]{facet_wrap}}.}
}
\value{
A profileplyr object
}
\description{
Function to convert soGGi ChIPprofile objects to  profileplyr object .
}
\examples{

example <- system.file("extdata", "example_deepTools_MAT", package = "profileplyr") 
object <- import_deepToolsMat(example)

generateProfilePlot(object)

}
