% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_benchmark.R
\name{Get_1region_ATAC_correlation}
\alias{Get_1region_ATAC_correlation}
\title{This function gets the average correlation rna seq counts and region effect on genes for genes which are only associated with 1 chromatin region}
\usage{
Get_1region_ATAC_correlation(counts, atacseq_data, region2gene)
}
\arguments{
\item{counts}{rna seq counts}

\item{atacseq_data}{atac seq data}

\item{region2gene}{a 0 1 coupling matrix between regions and genes of shape (nregions) x (num_genes), where a value of 1 indicates the gene is affected by a particular region}
}
\value{
the correlation value
}
\description{
This function gets the average correlation rna seq counts and region effect on genes for genes which are only associated with 1 chromatin region
}
\examples{
\donttest{
results <- sim_example(ncells = 10)
Get_1region_ATAC_correlation(results$counts, results$atacseq_data, results$region_to_gene)
}
}
