% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_technoise.R
\name{True2ObservedATAC}
\alias{True2ObservedATAC}
\title{Simulate observed ATAC-seq matrix given technical noise and the true counts}
\usage{
True2ObservedATAC(
  atacseq_data,
  randseed,
  observation_prob = 0.3,
  sd_frac = 0.1
)
}
\arguments{
\item{atacseq_data}{true ATAC-seq data}

\item{randseed}{(should produce same result if nregions, nevf and randseed are all the same)}

\item{observation_prob}{for each integer count of a particular region for a particular cell, the probability the count will be observed}

\item{sd_frac}{the fraction of ATAC-seq data value used as the standard deviation of added normally distrubted noise}
}
\value{
a matrix of observed ATAC-seq data
}
\description{
Simulate observed ATAC-seq matrix given technical noise and the true counts
}
\examples{
results <- sim_example(ncells = 10)
True2ObservedATAC(results$atac_counts, randseed = 1)
}
