% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_technoise.R
\name{True2ObservedCounts}
\alias{True2ObservedCounts}
\title{Simulate observed count matrix given technical biases and the true counts}
\usage{
True2ObservedCounts(
  true_counts,
  meta_cell,
  protocol,
  randseed,
  alpha_mean = 0.1,
  alpha_sd = 0.002,
  alpha_gene_mean = 1,
  alpha_gene_sd = 0,
  gene_len,
  depth_mean,
  depth_sd,
  lenslope = 0.02,
  nbins = 20,
  amp_bias_limit = c(-0.2, 0.2),
  rate_2PCR = 0.8,
  nPCR1 = 16,
  nPCR2 = 10,
  LinearAmp = FALSE,
  LinearAmp_coef = 2000
)
}
\arguments{
\item{true_counts}{gene cell matrix}

\item{meta_cell}{the meta information related to cells, will be combined with technical cell level information and returned}

\item{protocol}{a string, can be "nonUMI" or "UMI"}

\item{randseed}{(should produce same result if nregions, nevf and randseed are all the same)}

\item{alpha_mean}{the mean of rate of subsampling of transcripts during capture step, default at 10 percent efficiency}

\item{alpha_sd}{the std of rate of subsampling of transcripts}

\item{alpha_gene_mean}{the per-gene scale factor of the alpha parameter, default at 1}

\item{alpha_gene_sd}{the standard deviation of the per-gene scale factor of the alpha parameter, default at 0}

\item{gene_len}{a vector with lengths of all genes}

\item{depth_mean}{mean of sequencing depth}

\item{depth_sd}{std of sequencing depth}

\item{lenslope}{amount of length bias}

\item{nbins}{number of bins for gene length}

\item{amp_bias_limit}{range of amplification bias for each gene, a vector of length ngenes}

\item{rate_2PCR}{PCR efficiency, usually very high, default is 0.8}

\item{nPCR1}{the number of PCR cycles in "pre-amplification" step, default is 16}

\item{nPCR2}{the number of PCR cycles used after fragmentation.}

\item{LinearAmp}{if linear amplification is used for pre-amplification step, default is FALSE}

\item{LinearAmp_coef}{the coeficient of linear amplification, that is, how many times each molecule is amplified by}
}
\value{
if UMI, a list with two elements, the first is the observed count matrix, the second is the metadata; if nonUMI, a matrix
}
\description{
Simulate observed count matrix given technical biases and the true counts
}
\examples{
\donttest{
results <- sim_example(ncells = 10)
data(gene_len_pool)
gene_len <- sample(gene_len_pool, results$num_genes, replace = FALSE)
True2ObservedCounts(
  results$counts, results$cell_meta, protocol = "nonUMI", randseed = 1,
  alpha_mean = 0.1, alpha_sd = 0.05, gene_len = gene_len, depth_mean = 1e5, depth_sd = 3e3
)
}
}
