% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.1_spatial.R
\name{cci_cell_type_params}
\alias{cci_cell_type_params}
\title{Generate cell-type level CCI parameters}
\usage{
cci_cell_type_params(
  tree,
  total.lr,
  ctype.lr = 4:6,
  step.size = 1,
  rand = TRUE,
  discrete = FALSE
)
}
\arguments{
\item{tree}{Use the same value for \code{sim_true_counts()}.}

\item{total.lr}{Total number of LR pairs in the database. Use the same value for \code{sim_true_counts()}.}

\item{ctype.lr}{If \code{rand} is \code{TRUE}, how many LR pairs should be enabled between each cell type pair. Should be a range, e.g. 4:6.}

\item{step.size}{Use the same value for \code{sim_true_counts()}.}

\item{rand}{Whether fill the matrix randomly}

\item{discrete}{Whether the cell population is discrete. Use the same value for \code{sim_true_counts()}.}
}
\value{
A 3D matrix of (n_cell_type, n_cell_type, n_lr). The value at (i, j, k) is 1 if there exist CCI of LR-pair k between cell type i and cell type j.
}
\description{
See the return value if you want to specify the cell-type level ground truth.
}
\examples{
cci_cell_type_params(Phyla3(), 100, 4:6, 0.5, TRUE, FALSE)

}
