% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rview.R
\name{rview}
\alias{rview}
\title{Visualize aligned reads}
\usage{
rview(
  bamGA,
  chr = "1",
  start = 1,
  end = max(BiocGenerics::end(bamGA)),
  legend = FALSE
)
}
\arguments{
\item{bamGA}{A GenomicAlignment object}

\item{chr}{Chromosome. Integer or "X", "Y", "MT".}

\item{start}{Genomic coordinate of the start position.}

\item{end}{Genomic coordinate of the end position.}

\item{legend}{Show legend. Default is FALSE.}
}
\value{
A ggplot object of aligned reads
}
\description{
Visualize read alignments for UMI tagged single cell RNA-sequencing data.
 Read names must contain UMI sequences at the end delimited by "\strong{:}".
 Arrow represents orientation of alignment. Reads are colored by their UMI
 and sorted by their start positions and UMI.
}
\examples{
data(bamExample, package = "scruff")
g <- rview(bamExample, chr = "MT", legend = TRUE)
g
}
