% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fit.wrap}
\alias{fit.wrap}
\title{Internal function}
\usage{
fit.wrap(y, z, dist, phi, pi, gamma, starts = 1, it.em = 100, epsilon = 1e-04)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{dist}{distributional assumption\strong{:}
character \code{"norm"} (Gaussian),
\code{"nbinom"} (negative bionomial),
or \code{"zinb"} (zero-inflated negative binomial)}

\item{phi}{dispersion parameters\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{starts}{restarts of the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{1})}

\item{it.em}{(maximum) number of iterations in the \code{EM} algorithm\strong{:}
positive integer (defaults to \code{100})}

\item{epsilon}{convergence criterion for the \code{EM} algorithm\strong{:}
non-negative numeric (defaults to \code{1e-04})}
}
\value{
This function returns the parameter estimates, the posterior probabilities,
and the likelihood.

\item{posterior}{probability of belonging to class 1\strong{:}
numeric vector of length \code{n}}
\item{converge}{path of the log-likelihood\strong{:}
numeric vector with maximum length \code{it.em}}
\item{estim0}{parameter estimates under \code{H0}\strong{:}
data frame}
\item{estim1}{parameter estimates under \code{H1}\strong{:}
data frame}
\item{loglik0}{log-likelihood under \code{H0}\strong{:}
numeric}
\item{loglik1}{log-likelihood under \code{H1}\strong{:}
numeric}
\item{lrts}{likelihood-ratio test statistic\strong{:}
positive numeric}
}
\description{
This function fits the semi-supervised mixture model multiple times.
It is called by \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\details{
The distributions are parametrised as follows:
\itemize{
\item Gaussian \cr
\code{y ~ N(mean,sd^2)} \cr
\code{E[y]=mean}  \cr
\code{Var[y]=sd^2}
\item Negative binomial \cr
\code{y ~ NB(mu,phi)} \cr
\code{E[y]=mu}  \cr
\code{Var[y]=mu+phi*mu^2}
\item Zero-inflated negative binomial \cr
\code{y ~ ZINB(mu,phi,pi)} \cr
\code{E[y]=(1-pi)*mu}
}
}
\examples{
# data simulation
n <- 100
z <- rep(0:1,each=n/2)
y <- rnorm(n=n,mean=2*z,sd=1)
z[(n/4):n] <- NA

# model fitting
fit.wrap(y,z,dist="norm")

}
\seealso{
This is an \code{\link{internal}} function.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
