% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{resam.lrts}
\alias{resam.lrts}
\title{Internal function}
\usage{
resam.lrts(y, z, dist, phi, pi, gamma, test, pass, ...)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{dist}{distributional assumption\strong{:}
character \code{"norm"} (Gaussian),
\code{"nbinom"} (negative bionomial),
or \code{"zinb"} (zero-inflated negative binomial)}

\item{phi}{dispersion parameters\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{test}{resampling procedure\strong{:}
character \code{"perm"} (permutation) or
\code{"boot"} (parametric bootstrap),
or \code{NULL}}

\item{pass}{parameters for parametric bootstrap algorithm}

\item{...}{settings \code{EM} algorithm\strong{:}
\code{starts}, \code{it.em} and \code{epsilon}
(see \code{\link{arguments}})}
}
\value{
This function returns a numeric.
}
\description{
This function resamples the data,
fits the semi-supervised mixture model,
and returns the likelihood ratio test statistic.
It is called by \code{\link{mixtura}}.
}
\examples{
# data simulation
n <- 100
z <- rep(0:1,each=n/2)
y <- rnorm(n=n,mean=2*z,sd=1)
z[(n/4):n] <- NA

# observed test statistic
fit.wrap(y=y,z=z,dist="norm")$lrts

# simulated test statistic
resam.lrts(y=y,z=z,dist="norm",
           phi=NULL,pi=NULL,gamma=NULL,
           test="perm",pass=NULL)

}
\seealso{
This is an \code{\link{internal}} function.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
