% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotScoreLandscape}
\alias{plotScoreLandscape}
\title{Plot landscape of two gene signatures scores}
\usage{
plotScoreLandscape(
  scoredf1,
  scoredf2,
  scorenames = c(),
  textSize = 1.2,
  isInteractive = FALSE,
  hexMin = 100
)
}
\arguments{
\item{scoredf1}{data.frame, result of the simpleScore() function which scores
the gene expression matrix against a gene set of interest}

\item{scoredf2}{data.frame, result of the simpleScore() function which scores
the gene expression matrix against another gene set of interest}

\item{scorenames}{character vector of length 2, names for the two scored gene
set/signatures stored in scoredf1 and scoredf2}

\item{textSize}{numeric, set the text size for the plot, default as 1.5}

\item{isInteractive}{boolean, whether the plot is interactive default as
FALSE}

\item{hexMin}{integer, the threshold which decides whether hex bin plot or
scatter plot is displayed, default as 100}
}
\value{
A ggplot object, a scatter plot, demonstrating the relationship
between scores from two signatures on the same set of samples.
}
\description{
This function takes two data frames which are outputs from the
simpleScore() function and plots the relationship between the two gene set
scores for samples in the gene expression matrix.Scoredf1 and Scoredf2 are
two scoring results of the same set of samples against two different gene
signatures. If you wish to use the plotting function but with some
customized inputs (instead of outputs from the \code{simpleScore} function), you
need to make sure the formats are the same To be specific, you need to have
column names "TotalScore" "TotalDispersion" "UpScore" "UpDispersion"
"DownScore" "DownDispersion" and rows names as samples.
}
\examples{
ranked <- rankGenes(toy_expr_se)
scoredf <- simpleScore(ranked, upSet = toy_gs_up, downSet = toy_gs_dn)
scoredf2 <- simpleScore(ranked, upSet = toy_gs_up)
plotScoreLandscape(scoredf, scoredf2)
}
