% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{group_by.flowFrame}
\alias{group_by.flowFrame}
\title{Group a flowFrame into a flowSet using one or more variables.}
\usage{
\method{group_by}{flowFrame}(.data, ..., .add = FALSE, .drop = dplyr::group_by_drop_default(.data))
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Unquoted variables or columns to group by according to .data's
\code{\link[flowCore]{featureNames}}.}

\item{.add}{Unused.}

\item{.drop}{Unused.}
}
\value{
A \code{\link[flowCore]{flowSet}} containing one
\code{\link[flowCore]{flowFrame}} for each of the unique combinations of columns
selected in .... Metadata about grouping columns will be stored in the output
\code{\link[flowCore]{flowSet}}'s \code{\link[Biobase]{pData}}.
}
\description{
Group a flowFrame into a flowSet using one or more variables.
}
\examples{
my_flowframe <-
  simulate_cytometry_data()$flowframe |>
    dplyr::mutate(
      random_group =
        sample(
          c("a", "b"),
          size = nrow(simulate_cytometry_data()$flowframe),
          replace = TRUE
        )
    )

 my_flowframe |>
   dplyr::group_by(random_group)

}
