% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_verbs.R
\name{nest.flowFrame}
\alias{nest.flowFrame}
\title{Nest a \code{\link[flowCore]{flowFrame}} into a \code{\link[flowCore]{flowSet}}}
\usage{
\method{nest}{flowFrame}(.data, ..., .by = NULL, .key = NULL, .names_sep = NULL)
}
\arguments{
\item{.data}{A \code{\link[flowCore]{flowFrame}}}

\item{...}{Columns to nest; these will appear in the inner \code{\link[flowCore]{flowFrame}}s
comprising the output \code{\link[flowCore]{flowSet}}.
Specified using name-variable pairs of the form new_col = c(col1, col2, col3).
The right hand side can be any valid tidyselect expression.
If not supplied, then ... is derived as all columns not selected by .by.}

\item{.by}{Columns to nest by; these will be stored in the
\code{\link[Biobase]{pData}} of the output \code{\link[flowCore]{flowSet}}.
.by can be used in place of or in conjunction with columns supplied through ....
If not supplied, then .by is derived as all columns not selected by ....}

\item{.key}{Unused.}

\item{.names_sep}{Unused.}
}
\value{
A \code{\link[flowCore]{flowSet}} wherein cells are grouped into
constituent \code{\link[flowCore]{flowFrame}}s based on which columns are used
to nest.
}
\description{
Nest a \code{\link[flowCore]{flowFrame}} into a \code{\link[flowCore]{flowSet}}
}
\examples{

my_flowframe <-
  simulate_cytometry_data()$flowframe |>
  dplyr::mutate(
    random_group =
      sample(
        c("a", "b"),
        size = nrow(simulate_cytometry_data()$flowframe),
        replace = TRUE
      )
  )
my_flowframe |>
  tidyr::nest(.by = random_group)

}
