% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tof_tbl.R
\name{tof_find_panel_info}
\alias{tof_find_panel_info}
\title{Use tidyFlowCore's opinionated heuristic for extracting a high-dimensional cytometry panel's channel-antigen pairs
from a flowFrame (read from a .fcs file.)}
\usage{
tof_find_panel_info(input_flowFrame)
}
\arguments{
\item{input_flowFrame}{A flowFrame (just read from an .fcs file) from which
a high-dimensional cytometry panel should be extracted}
}
\value{
A tibble with 4 columns (`channels`, `antigens`, `.flowCore_featureNames`
and `.flowCore_colnames`). The first two columns correspond to the
channels and antigens of the high-dimensional cytometry panel used during
data acquisition, respectively. The last two channels represent the featureNames
and colnames attributes used to represent each channel in the input flowFrame.
}
\description{
Using the character vectors obtained from the `name` and `desc` columns of
the parameters of the data of a flowFrame, infer the cytometry panel used
to collect the data and return it as a tidy tibble.
}
