% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varTypes.R
\name{varTypes}
\alias{varTypes}
\title{Identify SNVs, Insertions and Deletions}
\usage{
varTypes(x, alt_col = "ALT", ...)
}
\arguments{
\item{x}{GenomicRanges object}

\item{alt_col}{Name of the column with mcols(x) which contains the alternate
allele. Can be an XStringSetList, XStringSet or character}

\item{...}{Not used}
}
\value{
Character vector
}
\description{
Identify SNVs, Insertions and Deletions within a GRanges object
}
\details{
Using the width of the reference and alternate alleles, classify each
range as an SNV, Insertion or Deletion.
\itemize{
\item SNVs are expected to have REF & ALT widths of 1
\item Insertions are expected to have ALT longer than REF
\item Deletions are expected to have ALT shorter than REF
}

These are relatively permissive criteria
}
\examples{
# Load the example VCF and classify ranges
library(VariantAnnotation)
f <- system.file("extdata/1000GP_subset.vcf.gz", package = "transmogR")
vcf <- readVcf(f)
gr <- rowRanges(vcf)
type <- varTypes(gr)
table(type)
gr[type != "SNV"]



}
