\name{BSgenome.Mfascicularis.NCBI.6.0}
\docType{package}

\alias{BSgenome.Mfascicularis.NCBI.6.0-package}
\alias{BSgenome.Mfascicularis.NCBI.6.0}
\alias{Mfascicularis}

\title{Full genome sequences for Macaca fascicularis (Macaca_fascicularis_6.0)}

\description{
  Full genome sequences for Macaca fascicularis (Crab-eating macaque) as provided by NCBI (assembly Macaca_fascicularis_6.0, assembly accession GCA_011100615.1) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
GCA_011100615.1_Macaca_fascicularis_6.0_genomic.fna.gz from https://ftp.ncbi.nlm.nih.gov/genomes/all/GCA/011/100/615/GCA_011100615.1_Macaca_fascicularis_6.0/
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Mfascicularis.NCBI.6.0
genome <- BSgenome.Mfascicularis.NCBI.6.0
head(seqlengths(genome))
genome[["1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
