% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_filter.R
\name{PAC_filter}
\alias{PAC_filter}
\title{Filter a PAC object on sequence size and coverage}
\usage{
PAC_filter(
  PAC,
  nucleotide_range = NULL,
  threshold = 0,
  coverage = 0,
  norm = "counts",
  subset_only = FALSE,
  stat = FALSE,
  pheno_target = NULL,
  anno_target = NULL,
  allbut = FALSE
)
}
\arguments{
\item{PAC}{PAC-list object containing an Anno data.frame with sequences as
row names and a Counts table with raw counts or counts per million (cpm).}

\item{nucleotide_range}{Integer vector giving the size interval, as c(min,max), that
should be saved (default=c(min,max)).}

\item{threshold}{Integer giving the threshold in counts or normalized counts
that needs to be reached for a sequence to be included (default=0).}

\item{coverage}{Integer giving the percent of independent samples that need
to reach the threshold for a sequence to be included (default=0).}

\item{norm}{Character specifying if filtering should be done using "counts",
"cpm" or another normalized data table in PAC$norm (default="counts").}

\item{subset_only}{Logical whether only subsetting using pheno_target and/or
anno_target should be done. If subset=FALSE (default) both subsetting and
other filtering will be done.}

\item{stat}{(optional) Logical specifying if a coverage graph should be
generated and if users should be prompted prior to proceeding.
(default=FALSE).}

\item{pheno_target}{(optional) List with: 
1st object being a character vector of target column in Pheno, 
2nd object being a character vector of the target group(s) in 
the target Pheno column (1st object).
(default=NULL)}

\item{anno_target}{(optional) List with: 
1st object being a character vector of target column in Anno, 2nd
object being a character vector of the target type/biotypes(s) in
the target Anno column (1st object).
(default=NULL)}

\item{allbut}{(optional) TRUE or FALSE to give option to include
all possible variables but the ones defined in pheno_target
and anno_target. Useful when you wish to for example filter out
one particular variable.}
}
\value{
A list of objects: 
              PAC object with filtered data.   
              (optional) A coverage plot
}
\description{
\code{PAC_filter} Filter PAC objects.
}
\details{
Given a PAC object the function will extract sequences within a given size
interval and percent coverage across independent samples.
}
\examples{
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                 package = "seqpac", mustWork = TRUE))

###--------------------------------------------------------------------- 
## Extracts all sequences between 10-80 nt in length with at 
## least 5 counts in 20\% of all samples.
pac_lowfilt <- PAC_filter(pac, nucleotide_range=c(10,80), threshold=5,
                         coverage=20, norm = "counts",
                         pheno_target=NULL, anno_target=NULL)

###--------------------------------------------------------------------- 
## Extracts sequences with 22 nt size and the samples in Batch1 and Batch2.
pac_subset <- PAC_filter(pac, subset_only = TRUE,
                        pheno_target=list("batch", c("Batch1", "Batch2")), 
                        anno_target=list("Size", "22"))

###--------------------------------------------------------------------- 
## Extracts all sequences with >=5 counts in 100\% of samples a within stage
filtsep <- PAC_filtsep(pac, norm="counts", threshold=5, 
                      coverage=100, pheno_target= list("stage"))

pac_filt <- PAC_filter(pac, subset_only = TRUE,
                     anno_target= unique(do.call("c", as.list(filtsep))))
                     
###--------------------------------------------------------------------- 
## Extract all biotypes but tRNA in all samples but in sample fastq_1

pac_filt <- PAC_filter(pac, anno_target=list("Biotypes_mis0","tRNA"),
                     pheno_target=list("sample","fastq1"), allbut=TRUE)



}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_jitter}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
