% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_PAC.R
\name{make_PAC}
\alias{make_PAC}
\title{Make PAC}
\usage{
make_PAC(counts, pheno = NULL, anno = NULL, output = "S4")
}
\arguments{
\item{counts}{Data.frame representing a counts table, with column names as
sample names and sequence names as row names. Contains the counts for each
sequence across the samples. Can be generated by the
\code{\link{make_counts}}.}

\item{pheno}{Data.frame with sample names as row names containing metadata
about each sample. Can be generated by the \code{\link{make_pheno}}
function.}

\item{anno}{Data.frame with unique sequences as row names containing metadata
about each sequence. If anno=NULL, a simple Anno data.frame will
automatically be generated from the the sequence names in counts.
Annotations for each sequence can be extended using for example the reanno
workflow (see vignette).}

\item{output}{Character indicating output format. If type="S4" (default),
then the PAC object is returned as an S4 object. If type="S3", the
PAC object will be returned as a list of data.frames}
}
\value{
Ordered PAC list object, checked for compatibility with downstream
  analysis in seqpac.
}
\description{
\code{make_PAC} Compiles, order and checks the assumptions of a PAC file.
}
\details{
Given a pheno, an anno and a counts data.frames the functions will safely
generate a simple PAC list-object.
}
\examples{

### First make counts 

# Seqpac includes strongly down-sampled smallRNA fastq.
sys_path = system.file("extdata", package = "seqpac", mustWork = TRUE)
input <- list.files(path = sys_path, pattern = "fastq", all.files = FALSE,
                full.names = TRUE)

# Notice that make_counts will generate another temp folder, that will 
# be emptied on finalization. By setting save_temp=TRUE you may save the 
# content.  
 
counts  <- make_counts(input, threads=2, parse="default_neb",
                       trimming="seqpac", plot=TRUE,
                       evidence=c(experiment=2, sample=1))

colnames(counts$counts)

### Then generate a phenotype table with make_pheno

#  Note:  'Sample_ID' column needs to be similar IDs as 
#          colnames in the counts table. You may also 
#          specify a path to a txt file.

Sample_ID <- colnames(counts$counts)

pheno <- data.frame(Sample_ID=Sample_ID,
                       Treatment=c(rep("heat", times=1), 
                                   rep("control", times=2)),
                       Batch=rep(c("1", "2", "3"), times=1)) 

pheno <- make_pheno(pheno=pheno, progress_report=counts$progress_report, 
                     counts=counts$counts)


pheno 

# Note that progress report from make_counts is added if you specify it  
     
### Lastly combine into PAC

pac <- make_PAC(pheno=pheno, counts=counts$counts)


pac
names(pac)

# Note: a simple annotation table is added automatically.
head(anno(pac))

# Clean up temp
closeAllConnections()
fls_temp  <- list.files(tempdir(), recursive=TRUE, full.names = TRUE)
file.remove(fls_temp, showWarnings=FALSE)

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC generation: 
\code{\link{PAC_check}()},
\code{\link{PAC_create}()},
\code{\link{make_counts}()},
\code{\link{make_cutadapt}()},
\code{\link{make_pheno}()},
\code{\link{make_trim}()},
\code{\link{merge_lanes}()}
}
\concept{PAC generation}
