% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pheno.R
\name{make_pheno}
\alias{make_pheno}
\title{Make Phenotype File}
\usage{
make_pheno(pheno, counts = NULL, progress_report = NULL)
}
\arguments{
\item{pheno}{Character vector with the path to a .csv file or a
data.frame with a column named "Sample_ID".}

\item{counts}{Data.frame object with the same column names as in
Sample_ID column of the pheno.}

\item{progress_report}{Data.frame object with progress report.}
}
\value{
A Pheno data.frame compatible with \code{\link{make_PAC}}
}
\description{
\code{make_pheno} generates a Pheno data.frame object containing additional
metadata for unique samples.
}
\details{
Given the path to a directory with a single csv file, the function will read
the file. Alternatively, a data.frame with sample information can be
provided. If provided with a count table, (see \code{\link{make_counts}}), it
will attempt to organize the row names according to the column names in
the counts table.
}
\examples{

### First make counts 

# Seqpac includes strongly down-sampled smallRNA fastq.
sys_path = system.file("extdata", package = "seqpac", mustWork = TRUE)
input <- list.files(path = sys_path, pattern = "fastq", all.files = FALSE,
                full.names = TRUE)

# Notice that make_counts will generate another temp folder, that will 
# be emptied on finalization. By setting save_temp=TRUE you may save the 
# content.  
 
counts  <- make_counts(input, threads=2, parse="default_neb",
                       trimming="seqpac", plot=TRUE,
                       evidence=c(experiment=2, sample=1))

colnames(counts$counts)

### Then generate a phenotype table with make_pheno

#  Note:  'Sample_ID' column needs to be similar IDs as 
#          colnames in the counts table. You may also 
#          specify a path to a txt file.

Sample_ID <- colnames(counts$counts)

pheno <- data.frame(Sample_ID=Sample_ID,
                       Treatment=c(rep("heat", times=1), 
                                   rep("control", times=2)),
                       Batch=rep(c("1", "2", "3"), times=1)) 

pheno <- make_pheno(pheno=pheno, progress_report=counts$progress_report, 
                     counts=counts$counts)


pheno 

# Note that progress report from make_counts is added if you specify it  
     
### Lastly combine into PAC

pac <- make_PAC(pheno=pheno, counts=counts$counts)


pac
names(pac)

# Note: a simple annotation table is added automatically.
head(anno(pac))

# Clean up temp
closeAllConnections()
fls_temp  <- list.files(tempdir(), recursive=TRUE, full.names = TRUE)
file.remove(fls_temp, showWarnings=FALSE)

}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC generation: 
\code{\link{PAC_check}()},
\code{\link{PAC_create}()},
\code{\link{make_PAC}()},
\code{\link{make_counts}()},
\code{\link{make_cutadapt}()},
\code{\link{make_trim}()},
\code{\link{merge_lanes}()}
}
\concept{PAC generation}
