/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombLongCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombLongEncoding
implements Encoding<Long> {
    private static final EncodingID ENCODING_ID = EncodingID.GOLOMB;
    private int m;
    private int offset;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int m) {
        GolombLongEncoding golombLongEncoding = new GolombLongEncoding();
        golombLongEncoding.offset = offset;
        golombLongEncoding.m = m;
        return new EncodingParams(ENCODING_ID, golombLongEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.m, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.offset = ITF8.readUnsignedITF8(buffer);
        this.m = ITF8.readUnsignedITF8(buffer);
    }

    @Override
    public BitCodec<Long> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new GolombLongCodec(this.offset, this.m);
    }
}

