/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare;

import edu.msu.cme.rdp.classifier.cli.CmdOptions;
import edu.msu.cme.rdp.classifier.io.ClassificationResultFormatter;
import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.MCSamplePrintUtil;
import edu.msu.cme.rdp.multicompare.MultiClassifier;
import edu.msu.cme.rdp.multicompare.MultiClassifierResult;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.multicompare.visitors.DefaultPrintVisitor;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.output.NullWriter;

public class Main {
    private static final Options options = new Options();

    public static void printResults(ConcretRoot<MCTaxon> root, List<MCSample> samples, PrintStream heirOut, PrintStream bootstrapOut) throws IOException {
        DefaultPrintVisitor printVisitor = new DefaultPrintVisitor(heirOut, samples);
        root.topDownVisit((TreeVisitor)printVisitor);
        for (MCSample sample : samples) {
            MCSamplePrintUtil.printBootstrapCountTable(bootstrapOut, sample);
        }
    }

    public static Map<String, String> readSampleMapping(String file) throws IOException {
        String line;
        HashMap<String, String> ret = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) continue;
            String seqid = line.split("\t")[0].trim();
            String sample = line.split("\t")[1].trim();
            ret.put(seqid, sample);
        }
        reader.close();
        return ret;
    }

    public static Map<String, Integer> readReplicateMapping(String file) throws IOException {
        String line;
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("")) continue;
            String seqid = line.split("\t")[0].trim();
            int replicates = Integer.valueOf(line.split("\t")[1].trim());
            ret.put(seqid, replicates);
        }
        reader.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        PrintStream hier_out = null;
        PrintWriter assign_out = new PrintWriter(new NullWriter());
        PrintStream bootstrap_out = null;
        File hier_out_filename = null;
        String propFile = null;
        File biomFile = null;
        File metadataFile = null;
        PrintWriter shortseq_out = null;
        ArrayList<MCSample> samples = new ArrayList<MCSample>();
        ClassificationResultFormatter.FORMAT format = ClassificationResultFormatter.FORMAT.allRank;
        float conf = CmdOptions.DEFAULT_CONF;
        String gene = null;
        int min_bootstrap_words = 5;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (!line.hasOption("o")) {
                throw new IllegalArgumentException("Require the output file for classification assignment");
            }
            assign_out = new PrintWriter(line.getOptionValue("o"));
            if (line.hasOption("h")) {
                hier_out_filename = new File(line.getOptionValue("h"));
                hier_out = new PrintStream(hier_out_filename);
            }
            if (line.hasOption("m")) {
                biomFile = new File(line.getOptionValue("m"));
            }
            if (line.hasOption("d")) {
                metadataFile = new File(line.getOptionValue("d"));
            }
            if (line.hasOption("t")) {
                if (gene != null) {
                    throw new IllegalArgumentException("Already specified the gene from the default location. Can not specify train_propfile");
                }
                propFile = line.getOptionValue("t");
            }
            if (line.hasOption("f")) {
                String f = line.getOptionValue("f");
                if (f.equalsIgnoreCase("allrank")) {
                    format = ClassificationResultFormatter.FORMAT.allRank;
                } else if (f.equalsIgnoreCase("fixrank")) {
                    format = ClassificationResultFormatter.FORMAT.fixRank;
                } else if (f.equalsIgnoreCase("filterbyconf")) {
                    format = ClassificationResultFormatter.FORMAT.filterbyconf;
                } else if (f.equalsIgnoreCase("db")) {
                    format = ClassificationResultFormatter.FORMAT.dbformat;
                } else if (f.equalsIgnoreCase("biom")) {
                    format = ClassificationResultFormatter.FORMAT.biom;
                } else {
                    throw new IllegalArgumentException("Not an valid output format, only allrank, fixrank, biom, filterbyconf and db allowed");
                }
            }
            if (line.hasOption("g")) {
                if (propFile != null) {
                    throw new IllegalArgumentException("Already specified train_propfile. Can not specify gene any more");
                }
                gene = line.getOptionValue("g").toLowerCase();
                if (!(gene.equals("16srrna") || gene.equals("fungallsu") || gene.equals("fungalits_warcup") || gene.equals("fungalits_unite"))) {
                    throw new IllegalArgumentException(gene + " not found, choose from" + "16srrna" + ", " + "fungallsu" + ", " + "fungalits_warcup" + ", " + "fungalits_unite");
                }
            }
            if (line.hasOption("w") && (min_bootstrap_words = Integer.parseInt(line.getOptionValue("w"))) < 5) {
                throw new IllegalArgumentException("minWords must be at least 5");
            }
            if (line.hasOption("c")) {
                String[] confString = line.getOptionValue("c");
                try {
                    conf = Float.valueOf((String)confString).floatValue();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Confidence must be a decimal number");
                }
                if (conf < 0.0f || conf > 1.0f) {
                    throw new IllegalArgumentException("Confidence must be in the range [0,1]");
                }
            }
            if (line.hasOption("s")) {
                shortseq_out = new PrintWriter(line.getOptionValue("s"));
            }
            if (line.hasOption("b")) {
                bootstrap_out = new PrintStream(line.getOptionValue("b"));
            }
            if (format.equals((Object)ClassificationResultFormatter.FORMAT.biom) && biomFile == null) {
                throw new IllegalArgumentException("biom format requires an input biom file");
            }
            if (biomFile != null) {
                format = ClassificationResultFormatter.FORMAT.biom;
            }
            for (String arg : args = line.getArgs()) {
                String[] inFileNames = arg.split(",");
                File inputFile = new File(inFileNames[0]);
                File idmappingFile = null;
                if (!inputFile.exists()) {
                    throw new IllegalArgumentException("Failed to find input file \"" + inFileNames[0] + "\"");
                }
                if (inFileNames.length == 2 && !(idmappingFile = new File(inFileNames[1])).exists()) {
                    throw new IllegalArgumentException("Failed to find input file \"" + inFileNames[1] + "\"");
                }
                MCSample nextSample = new MCSample(inputFile, idmappingFile);
                samples.add(nextSample);
            }
            if (propFile == null && gene == null) {
                gene = CmdOptions.DEFAULT_GENE;
            }
            if (samples.size() < 1) {
                throw new IllegalArgumentException("Require at least one sample files");
            }
        }
        catch (Exception e) {
            System.out.println("Command Error: " + e.getMessage());
            new HelpFormatter().printHelp(80, " [options] <samplefile>[,idmappingfile] ...", "", options, "");
            return;
        }
        MultiClassifier multiClassifier = new MultiClassifier(propFile, gene, biomFile, metadataFile);
        MultiClassifierResult result = multiClassifier.multiCompare(samples, conf, assign_out, format, min_bootstrap_words);
        assign_out.close();
        if (hier_out != null) {
            DefaultPrintVisitor printVisitor = new DefaultPrintVisitor(hier_out, samples);
            result.getRoot().topDownVisit((TreeVisitor)printVisitor);
            hier_out.close();
            if (multiClassifier.hasCopyNumber()) {
                File cn_corrected_s = new File(hier_out_filename.getParentFile(), "cnadjusted_" + hier_out_filename.getName());
                PrintStream cn_corrected_hier_out = new PrintStream(cn_corrected_s);
                printVisitor = new DefaultPrintVisitor(cn_corrected_hier_out, samples, true);
                result.getRoot().topDownVisit((TreeVisitor)printVisitor);
                cn_corrected_hier_out.close();
            }
        }
        if (bootstrap_out != null) {
            for (MCSample sample : samples) {
                MCSamplePrintUtil.printBootstrapCountTable(bootstrap_out, sample);
            }
            bootstrap_out.close();
        }
        if (shortseq_out != null) {
            for (String id : result.getBadSequences()) {
                shortseq_out.write(id + "\n");
            }
            shortseq_out.close();
        }
    }

    static {
        options.addOption(new Option("q", "queryFile", false, "legacy option, no longer needed "));
        options.addOption(new Option("o", "outputFile", true, "tab-delimited text output file for classification assignment."));
        options.addOption(new Option("t", "train_propfile", true, "property file containing the mapping of the training files if not using the default. Note: the training files and the property file should be in the same directory."));
        options.addOption(new Option("f", "format", true, CmdOptions.FORMAT_DESC));
        options.addOption(new Option("g", "gene", true, CmdOptions.GENE_DESC));
        options.addOption(new Option("w", "minWords", true, "minimum number of words for each bootstrap trial. Default(maximum) is 1/8 of the words of each sequence. Minimum is 5"));
        options.addOption(new Option("h", "hier_outfile", true, "tab-delimited output file containing the assignment count for each taxon in the hierarchical format. Default is null."));
        options.addOption(new Option("c", "conf", true, CmdOptions.BOOTSTRAP_DESC));
        options.addOption(new Option("b", "bootstrap_outfile", true, "the output file containing the number of matching assignments out of 100 bootstraps for major ranks. Default is null"));
        options.addOption(new Option("s", "shortseq_outfile", true, "the output file containing the sequence names that are too short to be classified"));
        options.addOption(new Option("m", "biomFile", true, "the input clluster biom file. The classification result will replace the taxonomy of the corresponding cluster id."));
        options.addOption(new Option("d", "metadata", true, "the tab delimited metadata file for the samples, with first row containing attribute name and first column containing the sample name"));
    }
}

