% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexmodel.R
\name{aFoldcomplexDesign}
\alias{aFoldcomplexDesign}
\title{Calculate parameters for differential expression test base on absolute counts differences}
\usage{
aFoldcomplexDesign(nncounts, design, condA, condB = NULL, lmodel = TRUE,
  preval = 0.05, qforkappa = 0, priorgenesd, ...)
}
\arguments{
\item{nncounts}{matrix for read count.}

\item{design}{a numeric matrix for expriment, with samples and factors in rows and colnums, respectively.}

\item{condA}{a vector of factors for DE analysis, which could be redundant.}

\item{condB}{a vector of factors for DE analysis, which could be redundant, default is null. If not provide, the DE analysis will switch to 
assess difference across factors in condA (analysis of variance). If provide, DE analysis will focus on contrast between condB and condA (condB-condA).}

\item{lmodel}{switch of fit linear model from limma-lmFit under design, default is TRUE. If TRUE, a gene-specific residual varaince will
be estimated from (satuarated model - reduced model). Satuarated model includes all factors in design matrix and reduced model includes factors in condA+condB.}

\item{preval}{pre-defined scale control for variance normalization, default is 0.05, a large value generally increases the fold-changes (decreases penalty of variances) under low expression.}

\item{qforkappa}{quantile for estimating kappa(>=qforkappa), default is 0 (without trimming of data). Please set up a value in [0,1) if you want to trim the low expressed data.}

\item{priorgenesd}{prior value  for general SD of fold change, if provided, the estimation of general SD will be replaced by this value.}

\item{...}{parameters passed to lmFit in limma}
}
\value{
A list with log2 foldchange, general SD (gene-specific SD if lmodel is TRUE) for calculating pvalue, variance stablized counts and basemean
}
\description{
Calculate aFold for each gene and general sd
}
\details{
shifted and calculate a set of parameters from normalized counts table
}
\note{
This function should run after \code{\link{normalFactors}}.
}
\examples{

data(simuN5)
groups=factor(simuN5$groups)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
mtx <- counts(obj,TRUE)
design <- model.matrix(~0+groups)
aFold <- aFoldcomplexDesign(mtx,design,condA=c("groups0"),condB=c("groups1"))
hist(aFold[[1]])

}
