% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Plotfuns.R
\name{plotDifftoBase}
\alias{plotDifftoBase}
\title{Plot absolute log2 fold-change against base mean of expression}
\usage{
plotDifftoBase(object, foldname = "foldChange", adj.pcut = 0.05,
  cols = c("black", "red"), pch = 16, xlab = "log2 of Expression level",
  ylab = "log2 fold-change", ...)
}
\arguments{
\item{object}{a ABSDataSet}

\item{foldname}{indicates kind of fold-change in plotting, default is 'foldChange', see \code{results}}

\item{adj.pcut}{cutoff for differential expressed genes, marked by different color, default is 0.05}

\item{cols}{the colors to mark the non-DE and DE genes, defualt is black and red, respectively}

\item{pch}{pch, default is 16}

\item{xlab}{xlab, default is 'log2 of Expression level'}

\item{ylab}{ylab, default is 'log2 fold-change'}

\item{...,}{further arguments to \code{plot}}
}
\description{
Plot absolute differencs against expression levels
}
\details{
Plot absolute differencs against expression levels
and mark the gene with a color at a given cutoff of fold-change
}
\examples{
data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- ABSSeq(obj)
plotDifftoBase(obj)
}

